package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackSetARN,
  StackSetName,
  StackSetId,
  RoleARN,
  Description,
  ExecutionRoleName,
  TemplateBody,
  OrganizationalUnitId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StackSet(
    stackSetName: Optional[StackSetName] = Optional.Absent,
    stackSetId: Optional[StackSetId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.cloudformation.model.StackSetStatus] =
      Optional.Absent,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudformation.model.Parameter]] =
      Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudformation.model.Tag]] =
      Optional.Absent,
    stackSetARN: Optional[StackSetARN] = Optional.Absent,
    administrationRoleARN: Optional[RoleARN] = Optional.Absent,
    executionRoleName: Optional[ExecutionRoleName] = Optional.Absent,
    stackSetDriftDetectionDetails: Optional[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails
    ] = Optional.Absent,
    autoDeployment: Optional[zio.aws.cloudformation.model.AutoDeployment] =
      Optional.Absent,
    permissionModel: Optional[zio.aws.cloudformation.model.PermissionModels] =
      Optional.Absent,
    organizationalUnitIds: Optional[Iterable[OrganizationalUnitId]] =
      Optional.Absent,
    managedExecution: Optional[zio.aws.cloudformation.model.ManagedExecution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSet = {
    import StackSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSet
      .builder()
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        stackSetARN.map(value => StackSetARN.unwrap(value): java.lang.String)
      )(_.stackSetARN)
      .optionallyWith(
        administrationRoleARN.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.administrationRoleARN)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(
        stackSetDriftDetectionDetails.map(value => value.buildAwsValue())
      )(_.stackSetDriftDetectionDetails)
      .optionallyWith(autoDeployment.map(value => value.buildAwsValue()))(
        _.autoDeployment
      )
      .optionallyWith(permissionModel.map(value => value.unwrap))(
        _.permissionModel
      )
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .optionallyWith(managedExecution.map(value => value.buildAwsValue()))(
        _.managedExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackSet.ReadOnly =
    zio.aws.cloudformation.model.StackSet.wrap(buildAwsValue())
}
object StackSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSet =
      zio.aws.cloudformation.model.StackSet(
        stackSetName.map(value => value),
        stackSetId.map(value => value),
        description.map(value => value),
        status.map(value => value),
        templateBody.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stackSetARN.map(value => value),
        administrationRoleARN.map(value => value),
        executionRoleName.map(value => value),
        stackSetDriftDetectionDetails.map(value => value.asEditable),
        autoDeployment.map(value => value.asEditable),
        permissionModel.map(value => value),
        organizationalUnitIds.map(value => value),
        managedExecution.map(value => value.asEditable)
      )
    def stackSetName: Optional[StackSetName]
    def stackSetId: Optional[StackSetId]
    def description: Optional[Description]
    def status: Optional[zio.aws.cloudformation.model.StackSetStatus]
    def templateBody: Optional[TemplateBody]
    def parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def tags: Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def stackSetARN: Optional[StackSetARN]
    def administrationRoleARN: Optional[RoleARN]
    def executionRoleName: Optional[ExecutionRoleName]
    def stackSetDriftDetectionDetails: Optional[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ]
    def autoDeployment
        : Optional[zio.aws.cloudformation.model.AutoDeployment.ReadOnly]
    def permissionModel: Optional[zio.aws.cloudformation.model.PermissionModels]
    def organizationalUnitIds: Optional[List[OrganizationalUnitId]]
    def managedExecution
        : Optional[zio.aws.cloudformation.model.ManagedExecution.ReadOnly]
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStackSetARN: ZIO[Any, AwsError, StackSetARN] =
      AwsError.unwrapOptionField("stackSetARN", stackSetARN)
    def getAdministrationRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("administrationRoleARN", administrationRoleARN)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getStackSetDriftDetectionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stackSetDriftDetectionDetails",
      stackSetDriftDetectionDetails
    )
    def getAutoDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AutoDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("autoDeployment", autoDeployment)
    def getPermissionModel
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PermissionModels] =
      AwsError.unwrapOptionField("permissionModel", permissionModel)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
    def getManagedExecution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ManagedExecution.ReadOnly
    ] = AwsError.unwrapOptionField("managedExecution", managedExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSet
  ) extends zio.aws.cloudformation.model.StackSet.ReadOnly {
    override val stackSetName: Optional[StackSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetName())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetName(value))
    override val stackSetId: Optional[StackSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val status: Optional[zio.aws.cloudformation.model.StackSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.cloudformation.model.StackSetStatus.wrap(value))
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val tags
        : Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val stackSetARN: Optional[StackSetARN] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetARN())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetARN(value))
    override val administrationRoleARN: Optional[RoleARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administrationRoleARN())
        .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val executionRoleName: Optional[ExecutionRoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleName())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ExecutionRoleName(value)
        )
    override val stackSetDriftDetectionDetails: Optional[
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetDriftDetectionDetails())
      .map(value =>
        zio.aws.cloudformation.model.StackSetDriftDetectionDetails.wrap(value)
      )
    override val autoDeployment
        : Optional[zio.aws.cloudformation.model.AutoDeployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoDeployment())
        .map(value => zio.aws.cloudformation.model.AutoDeployment.wrap(value))
    override val permissionModel
        : Optional[zio.aws.cloudformation.model.PermissionModels] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionModel())
        .map(value => zio.aws.cloudformation.model.PermissionModels.wrap(value))
    override val organizationalUnitIds: Optional[List[OrganizationalUnitId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
    override val managedExecution
        : Optional[zio.aws.cloudformation.model.ManagedExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedExecution())
        .map(value => zio.aws.cloudformation.model.ManagedExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSet
  ): zio.aws.cloudformation.model.StackSet.ReadOnly = new Wrapper(impl)
}
