package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StackInstanceComprehensiveStatus(
    detailedStatus: Optional[
      zio.aws.cloudformation.model.StackInstanceDetailedStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackInstanceComprehensiveStatus = {
    import StackInstanceComprehensiveStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackInstanceComprehensiveStatus
      .builder()
      .optionallyWith(detailedStatus.map(value => value.unwrap))(
        _.detailedStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly =
    zio.aws.cloudformation.model.StackInstanceComprehensiveStatus
      .wrap(buildAwsValue())
}
object StackInstanceComprehensiveStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackInstanceComprehensiveStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.StackInstanceComprehensiveStatus =
      zio.aws.cloudformation.model
        .StackInstanceComprehensiveStatus(detailedStatus.map(value => value))
    def detailedStatus
        : Optional[zio.aws.cloudformation.model.StackInstanceDetailedStatus]
    def getDetailedStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackInstanceDetailedStatus
    ] = AwsError.unwrapOptionField("detailedStatus", detailedStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstanceComprehensiveStatus
  ) extends zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly {
    override val detailedStatus
        : Optional[zio.aws.cloudformation.model.StackInstanceDetailedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detailedStatus())
        .map(value =>
          zio.aws.cloudformation.model.StackInstanceDetailedStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstanceComprehensiveStatus
  ): zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly =
    new Wrapper(impl)
}
