package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.AccountGateStatusReason
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountGateResult(
    status: Optional[zio.aws.cloudformation.model.AccountGateStatus] =
      Optional.Absent,
    statusReason: Optional[AccountGateStatusReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.AccountGateResult = {
    import AccountGateResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.AccountGateResult
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          AccountGateStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.AccountGateResult.ReadOnly =
    zio.aws.cloudformation.model.AccountGateResult.wrap(buildAwsValue())
}
object AccountGateResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.AccountGateResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.AccountGateResult =
      zio.aws.cloudformation.model.AccountGateResult(
        status.map(value => value),
        statusReason.map(value => value)
      )
    def status: Optional[zio.aws.cloudformation.model.AccountGateStatus]
    def statusReason: Optional[AccountGateStatusReason]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.AccountGateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, AccountGateStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.AccountGateResult
  ) extends zio.aws.cloudformation.model.AccountGateResult.ReadOnly {
    override val status
        : Optional[zio.aws.cloudformation.model.AccountGateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cloudformation.model.AccountGateStatus.wrap(value)
        )
    override val statusReason: Optional[AccountGateStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives.AccountGateStatusReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.AccountGateResult
  ): zio.aws.cloudformation.model.AccountGateResult.ReadOnly = new Wrapper(impl)
}
