package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTypesRequest(
    visibility: Optional[zio.aws.cloudformation.model.Visibility] =
      Optional.Absent,
    provisioningType: Optional[zio.aws.cloudformation.model.ProvisioningType] =
      Optional.Absent,
    deprecatedStatus: Optional[zio.aws.cloudformation.model.DeprecatedStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      Optional.Absent,
    filters: Optional[zio.aws.cloudformation.model.TypeFilters] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypesRequest = {
    import ListTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
      .builder()
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(provisioningType.map(value => value.unwrap))(
        _.provisioningType
      )
      .optionallyWith(deprecatedStatus.map(value => value.unwrap))(
        _.deprecatedStatus
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListTypesRequest.ReadOnly =
    zio.aws.cloudformation.model.ListTypesRequest.wrap(buildAwsValue())
}
object ListTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypesRequest =
      zio.aws.cloudformation.model.ListTypesRequest(
        visibility.map(value => value),
        provisioningType.map(value => value),
        deprecatedStatus.map(value => value),
        `type`.map(value => value),
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def visibility: Optional[zio.aws.cloudformation.model.Visibility]
    def provisioningType
        : Optional[zio.aws.cloudformation.model.ProvisioningType]
    def deprecatedStatus
        : Optional[zio.aws.cloudformation.model.DeprecatedStatus]
    def `type`: Optional[zio.aws.cloudformation.model.RegistryType]
    def filters: Optional[zio.aws.cloudformation.model.TypeFilters.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.Visibility] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getProvisioningType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ProvisioningType] =
      AwsError.unwrapOptionField("provisioningType", provisioningType)
    def getDeprecatedStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.DeprecatedStatus] =
      AwsError.unwrapOptionField("deprecatedStatus", deprecatedStatus)
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.TypeFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
  ) extends zio.aws.cloudformation.model.ListTypesRequest.ReadOnly {
    override val visibility: Optional[zio.aws.cloudformation.model.Visibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visibility())
        .map(value => zio.aws.cloudformation.model.Visibility.wrap(value))
    override val provisioningType
        : Optional[zio.aws.cloudformation.model.ProvisioningType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningType())
        .map(value => zio.aws.cloudformation.model.ProvisioningType.wrap(value))
    override val deprecatedStatus
        : Optional[zio.aws.cloudformation.model.DeprecatedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecatedStatus())
        .map(value => zio.aws.cloudformation.model.DeprecatedStatus.wrap(value))
    override val `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val filters
        : Optional[zio.aws.cloudformation.model.TypeFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.cloudformation.model.TypeFilters.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesRequest
  ): zio.aws.cloudformation.model.ListTypesRequest.ReadOnly = new Wrapper(impl)
}
