package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait CallAs {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.CallAs
}
object CallAs {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.CallAs
  ): zio.aws.cloudformation.model.CallAs = value match {
    case software.amazon.awssdk.services.cloudformation.model.CallAs.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.CallAs.SELF =>
      val r = SELF
      r
    case software.amazon.awssdk.services.cloudformation.model.CallAs.DELEGATED_ADMIN =>
      val r = DELEGATED_ADMIN
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudformation.model.CallAs {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.CallAs =
      software.amazon.awssdk.services.cloudformation.model.CallAs.UNKNOWN_TO_SDK_VERSION
  }
  case object SELF extends zio.aws.cloudformation.model.CallAs {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.CallAs =
      software.amazon.awssdk.services.cloudformation.model.CallAs.SELF
  }
  case object DELEGATED_ADMIN extends zio.aws.cloudformation.model.CallAs {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.CallAs =
      software.amazon.awssdk.services.cloudformation.model.CallAs.DELEGATED_ADMIN
  }
}
