package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackSetOperationStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus
}
object StackSetOperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus
  ): zio.aws.cloudformation.model.StackSetOperationStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.QUEUED =>
      val r = QUEUED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackSetOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING
      extends zio.aws.cloudformation.model.StackSetOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.RUNNING
  }
  case object SUCCEEDED
      extends zio.aws.cloudformation.model.StackSetOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.SUCCEEDED
  }
  case object FAILED
      extends zio.aws.cloudformation.model.StackSetOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.FAILED
  }
  case object STOPPING
      extends zio.aws.cloudformation.model.StackSetOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.STOPPING
  }
  case object STOPPED
      extends zio.aws.cloudformation.model.StackSetOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.STOPPED
  }
  case object QUEUED
      extends zio.aws.cloudformation.model.StackSetOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus.QUEUED
  }
}
