package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  OrganizationalUnitId,
  Reason,
  Region,
  Account
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StackSetOperationResultSummary(
    account: Optional[Account] = Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    status: Optional[
      zio.aws.cloudformation.model.StackSetOperationResultStatus
    ] = Optional.Absent,
    statusReason: Optional[Reason] = Optional.Absent,
    accountGateResult: Optional[
      zio.aws.cloudformation.model.AccountGateResult
    ] = Optional.Absent,
    organizationalUnitId: Optional[OrganizationalUnitId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary = {
    import StackSetOperationResultSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary
      .builder()
      .optionallyWith(
        account.map(value => Account.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(accountGateResult.map(value => value.buildAwsValue()))(
        _.accountGateResult
      )
      .optionallyWith(
        organizationalUnitId.map(value =>
          OrganizationalUnitId.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly =
    zio.aws.cloudformation.model.StackSetOperationResultSummary
      .wrap(buildAwsValue())
}
object StackSetOperationResultSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.StackSetOperationResultSummary =
      zio.aws.cloudformation.model.StackSetOperationResultSummary(
        account.map(value => value),
        region.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        accountGateResult.map(value => value.asEditable),
        organizationalUnitId.map(value => value)
      )
    def account: Optional[Account]
    def region: Optional[Region]
    def status
        : Optional[zio.aws.cloudformation.model.StackSetOperationResultStatus]
    def statusReason: Optional[Reason]
    def accountGateResult
        : Optional[zio.aws.cloudformation.model.AccountGateResult.ReadOnly]
    def organizationalUnitId: Optional[OrganizationalUnitId]
    def getAccount: ZIO[Any, AwsError, Account] =
      AwsError.unwrapOptionField("account", account)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationResultStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getAccountGateResult: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AccountGateResult.ReadOnly
    ] = AwsError.unwrapOptionField("accountGateResult", accountGateResult)
    def getOrganizationalUnitId: ZIO[Any, AwsError, OrganizationalUnitId] =
      AwsError.unwrapOptionField("organizationalUnitId", organizationalUnitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary
  ) extends zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly {
    override val account: Optional[Account] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.cloudformation.model.primitives.Account(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.cloudformation.model.primitives.Region(value))
    override val status
        : Optional[zio.aws.cloudformation.model.StackSetOperationResultStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cloudformation.model.StackSetOperationResultStatus.wrap(value)
        )
    override val statusReason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.cloudformation.model.primitives.Reason(value))
    override val accountGateResult
        : Optional[zio.aws.cloudformation.model.AccountGateResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountGateResult())
        .map(value =>
          zio.aws.cloudformation.model.AccountGateResult.wrap(value)
        )
    override val organizationalUnitId: Optional[OrganizationalUnitId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.OrganizationalUnitId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary
  ): zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly =
    new Wrapper(impl)
}
