package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackSetOperationAction {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction
}
object StackSetOperationAction {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction
  ): zio.aws.cloudformation.model.StackSetOperationAction = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.DETECT_DRIFT =>
      val r = DETECT_DRIFT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackSetOperationAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE
      extends zio.aws.cloudformation.model.StackSetOperationAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.CREATE
  }
  case object UPDATE
      extends zio.aws.cloudformation.model.StackSetOperationAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.UPDATE
  }
  case object DELETE
      extends zio.aws.cloudformation.model.StackSetOperationAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.DELETE
  }
  case object DETECT_DRIFT
      extends zio.aws.cloudformation.model.StackSetOperationAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction =
      software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction.DETECT_DRIFT
  }
}
