package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  NextToken,
  StackNameOrId,
  ChangeSetNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChangeSetHooksRequest(
    changeSetName: ChangeSetNameOrId,
    stackName: Optional[StackNameOrId] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    logicalResourceId: Optional[LogicalResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest = {
    import DescribeChangeSetHooksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
      .builder()
      .changeSetName(ChangeSetNameOrId.unwrap(changeSetName): java.lang.String)
      .optionallyWith(
        stackName.map(value => StackNameOrId.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeChangeSetHooksRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeChangeSetHooksRequest
      .wrap(buildAwsValue())
}
object DescribeChangeSetHooksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeChangeSetHooksRequest =
      zio.aws.cloudformation.model.DescribeChangeSetHooksRequest(
        changeSetName,
        stackName.map(value => value),
        nextToken.map(value => value),
        logicalResourceId.map(value => value)
      )
    def changeSetName: ChangeSetNameOrId
    def stackName: Optional[StackNameOrId]
    def nextToken: Optional[NextToken]
    def logicalResourceId: Optional[LogicalResourceId]
    def getChangeSetName: ZIO[Any, Nothing, ChangeSetNameOrId] =
      ZIO.succeed(changeSetName)
    def getStackName: ZIO[Any, AwsError, StackNameOrId] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
  ) extends zio.aws.cloudformation.model.DescribeChangeSetHooksRequest.ReadOnly {
    override val changeSetName: ChangeSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .ChangeSetNameOrId(impl.changeSetName())
    override val stackName: Optional[StackNameOrId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackNameOrId(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val logicalResourceId: Optional[LogicalResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logicalResourceId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.LogicalResourceId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest
  ): zio.aws.cloudformation.model.DescribeChangeSetHooksRequest.ReadOnly =
    new Wrapper(impl)
}
