package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  StackNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectStackDriftRequest(
    stackName: StackNameOrId,
    logicalResourceIds: Optional[Iterable[LogicalResourceId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest = {
    import DetectStackDriftRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .optionallyWith(
        logicalResourceIds.map(value =>
          value.map { item =>
            LogicalResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.logicalResourceIds)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DetectStackDriftRequest.ReadOnly =
    zio.aws.cloudformation.model.DetectStackDriftRequest.wrap(buildAwsValue())
}
object DetectStackDriftRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DetectStackDriftRequest =
      zio.aws.cloudformation.model.DetectStackDriftRequest(
        stackName,
        logicalResourceIds.map(value => value)
      )
    def stackName: StackNameOrId
    def logicalResourceIds: Optional[List[LogicalResourceId]]
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getLogicalResourceIds: ZIO[Any, AwsError, List[LogicalResourceId]] =
      AwsError.unwrapOptionField("logicalResourceIds", logicalResourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest
  ) extends zio.aws.cloudformation.model.DetectStackDriftRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val logicalResourceIds: Optional[List[LogicalResourceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logicalResourceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.LogicalResourceId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest
  ): zio.aws.cloudformation.model.DetectStackDriftRequest.ReadOnly =
    new Wrapper(impl)
}
