package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTypesResponse(
    typeSummaries: Optional[
      Iterable[zio.aws.cloudformation.model.TypeSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypesResponse = {
    import ListTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
      .builder()
      .optionallyWith(
        typeSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.typeSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListTypesResponse.ReadOnly =
    zio.aws.cloudformation.model.ListTypesResponse.wrap(buildAwsValue())
}
object ListTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypesResponse =
      zio.aws.cloudformation.model.ListTypesResponse(
        typeSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def typeSummaries
        : Optional[List[zio.aws.cloudformation.model.TypeSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTypeSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("typeSummaries", typeSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
  ) extends zio.aws.cloudformation.model.ListTypesResponse.ReadOnly {
    override val typeSummaries
        : Optional[List[zio.aws.cloudformation.model.TypeSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.TypeSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypesResponse
  ): zio.aws.cloudformation.model.ListTypesResponse.ReadOnly = new Wrapper(impl)
}
