package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.RegistrationToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeTypeRegistrationRequest(
    registrationToken: RegistrationToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest = {
    import DescribeTypeRegistrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest
      .builder()
      .registrationToken(
        RegistrationToken.unwrap(registrationToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeTypeRegistrationRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeTypeRegistrationRequest
      .wrap(buildAwsValue())
}
object DescribeTypeRegistrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeTypeRegistrationRequest =
      zio.aws.cloudformation.model
        .DescribeTypeRegistrationRequest(registrationToken)
    def registrationToken: RegistrationToken
    def getRegistrationToken: ZIO[Any, Nothing, RegistrationToken] =
      ZIO.succeed(registrationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest
  ) extends zio.aws.cloudformation.model.DescribeTypeRegistrationRequest.ReadOnly {
    override val registrationToken: RegistrationToken =
      zio.aws.cloudformation.model.primitives
        .RegistrationToken(impl.registrationToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest
  ): zio.aws.cloudformation.model.DescribeTypeRegistrationRequest.ReadOnly =
    new Wrapper(impl)
}
