package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStackResourceResponse(
    stackResourceDetail: Optional[
      zio.aws.cloudformation.model.StackResourceDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse = {
    import DescribeStackResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
      .builder()
      .optionallyWith(stackResourceDetail.map(value => value.buildAwsValue()))(
        _.stackResourceDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackResourceResponse
      .wrap(buildAwsValue())
}
object DescribeStackResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackResourceResponse =
      zio.aws.cloudformation.model.DescribeStackResourceResponse(
        stackResourceDetail.map(value => value.asEditable)
      )
    def stackResourceDetail
        : Optional[zio.aws.cloudformation.model.StackResourceDetail.ReadOnly]
    def getStackResourceDetail: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceDetail.ReadOnly
    ] = AwsError.unwrapOptionField("stackResourceDetail", stackResourceDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
  ) extends zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly {
    override val stackResourceDetail
        : Optional[zio.aws.cloudformation.model.StackResourceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackResourceDetail())
        .map(value =>
          zio.aws.cloudformation.model.StackResourceDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse
  ): zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly =
    new Wrapper(impl)
}
