package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  Account,
  Timestamp,
  StackSetId,
  StackId,
  Region,
  OrganizationalUnitId,
  Reason
}
import scala.jdk.CollectionConverters._
final case class StackInstance(
    stackSetId: Optional[StackSetId] = Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    account: Optional[Account] = Optional.Absent,
    stackId: Optional[StackId] = Optional.Absent,
    parameterOverrides: Optional[
      Iterable[zio.aws.cloudformation.model.Parameter]
    ] = Optional.Absent,
    status: Optional[zio.aws.cloudformation.model.StackInstanceStatus] =
      Optional.Absent,
    stackInstanceStatus: Optional[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus
    ] = Optional.Absent,
    statusReason: Optional[Reason] = Optional.Absent,
    organizationalUnitId: Optional[OrganizationalUnitId] = Optional.Absent,
    driftStatus: Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      Optional.Absent,
    lastDriftCheckTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackInstance = {
    import StackInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackInstance
      .builder()
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        account.map(value => Account.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        parameterOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterOverrides)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(stackInstanceStatus.map(value => value.buildAwsValue()))(
        _.stackInstanceStatus
      )
      .optionallyWith(
        statusReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        organizationalUnitId.map(value =>
          OrganizationalUnitId.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitId)
      .optionallyWith(driftStatus.map(value => value.unwrap))(_.driftStatus)
      .optionallyWith(
        lastDriftCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDriftCheckTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackInstance.ReadOnly =
    zio.aws.cloudformation.model.StackInstance.wrap(buildAwsValue())
}
object StackInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackInstance =
      zio.aws.cloudformation.model.StackInstance(
        stackSetId.map(value => value),
        region.map(value => value),
        account.map(value => value),
        stackId.map(value => value),
        parameterOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        stackInstanceStatus.map(value => value.asEditable),
        statusReason.map(value => value),
        organizationalUnitId.map(value => value),
        driftStatus.map(value => value),
        lastDriftCheckTimestamp.map(value => value)
      )
    def stackSetId: Optional[StackSetId]
    def region: Optional[Region]
    def account: Optional[Account]
    def stackId: Optional[StackId]
    def parameterOverrides
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def status: Optional[zio.aws.cloudformation.model.StackInstanceStatus]
    def stackInstanceStatus: Optional[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ]
    def statusReason: Optional[Reason]
    def organizationalUnitId: Optional[OrganizationalUnitId]
    def driftStatus: Optional[zio.aws.cloudformation.model.StackDriftStatus]
    def lastDriftCheckTimestamp: Optional[Timestamp]
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getAccount: ZIO[Any, AwsError, Account] =
      AwsError.unwrapOptionField("account", account)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getParameterOverrides: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterOverrides", parameterOverrides)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackInstanceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStackInstanceStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ] = AwsError.unwrapOptionField("stackInstanceStatus", stackInstanceStatus)
    def getStatusReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getOrganizationalUnitId: ZIO[Any, AwsError, OrganizationalUnitId] =
      AwsError.unwrapOptionField("organizationalUnitId", organizationalUnitId)
    def getDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackDriftStatus] =
      AwsError.unwrapOptionField("driftStatus", driftStatus)
    def getLastDriftCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDriftCheckTimestamp", lastDriftCheckTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstance
  ) extends zio.aws.cloudformation.model.StackInstance.ReadOnly {
    override val stackSetId: Optional[StackSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.cloudformation.model.primitives.Region(value))
    override val account: Optional[Account] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.cloudformation.model.primitives.Account(value))
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val parameterOverrides
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val status
        : Optional[zio.aws.cloudformation.model.StackInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cloudformation.model.StackInstanceStatus.wrap(value)
        )
    override val stackInstanceStatus: Optional[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stackInstanceStatus())
      .map(value =>
        zio.aws.cloudformation.model.StackInstanceComprehensiveStatus
          .wrap(value)
      )
    override val statusReason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.cloudformation.model.primitives.Reason(value))
    override val organizationalUnitId: Optional[OrganizationalUnitId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.OrganizationalUnitId(value)
        )
    override val driftStatus
        : Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftStatus())
        .map(value => zio.aws.cloudformation.model.StackDriftStatus.wrap(value))
    override val lastDriftCheckTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDriftCheckTimestamp())
        .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstance
  ): zio.aws.cloudformation.model.StackInstance.ReadOnly = new Wrapper(impl)
}
