package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStackResourceDriftsResponse(
    stackResourceDrifts: Iterable[
      zio.aws.cloudformation.model.StackResourceDrift
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse = {
    import DescribeStackResourceDriftsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse
      .builder()
      .stackResourceDrifts(stackResourceDrifts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse
      .wrap(buildAwsValue())
}
object DescribeStackResourceDriftsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse =
      zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse(
        stackResourceDrifts.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def stackResourceDrifts
        : List[zio.aws.cloudformation.model.StackResourceDrift.ReadOnly]
    def nextToken: Optional[NextToken]
    def getStackResourceDrifts: ZIO[Any, Nothing, List[
      zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
    ]] = ZIO.succeed(stackResourceDrifts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse
  ) extends zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly {
    override val stackResourceDrifts
        : List[zio.aws.cloudformation.model.StackResourceDrift.ReadOnly] = impl
      .stackResourceDrifts()
      .asScala
      .map { item =>
        zio.aws.cloudformation.model.StackResourceDrift.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse
  ): zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly =
    new Wrapper(impl)
}
