package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackStatus
}
object StackStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackStatus
  ): zio.aws.cloudformation.model.StackStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.ROLLBACK_IN_PROGRESS =>
      val r = ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.ROLLBACK_FAILED =>
      val r = ROLLBACK_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.ROLLBACK_COMPLETE =>
      val r = ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.DELETE_COMPLETE =>
      val r = DELETE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_COMPLETE_CLEANUP_IN_PROGRESS =>
      val r = UPDATE_COMPLETE_CLEANUP_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_COMPLETE =>
      val r = UPDATE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_IN_PROGRESS =>
      val r = UPDATE_ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_FAILED =>
      val r = UPDATE_ROLLBACK_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS =>
      val r = UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_COMPLETE =>
      val r = UPDATE_ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.REVIEW_IN_PROGRESS =>
      val r = REVIEW_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_IN_PROGRESS =>
      val r = IMPORT_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_COMPLETE =>
      val r = IMPORT_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_ROLLBACK_IN_PROGRESS =>
      val r = IMPORT_ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_ROLLBACK_FAILED =>
      val r = IMPORT_ROLLBACK_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_ROLLBACK_COMPLETE =>
      val r = IMPORT_ROLLBACK_COMPLETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.CREATE_FAILED
  }
  case object CREATE_COMPLETE extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.CREATE_COMPLETE
  }
  case object ROLLBACK_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.ROLLBACK_IN_PROGRESS
  }
  case object ROLLBACK_FAILED extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.ROLLBACK_FAILED
  }
  case object ROLLBACK_COMPLETE
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.ROLLBACK_COMPLETE
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.DELETE_FAILED
  }
  case object DELETE_COMPLETE extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.DELETE_COMPLETE
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_COMPLETE_CLEANUP_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_COMPLETE_CLEANUP_IN_PROGRESS
  }
  case object UPDATE_COMPLETE extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_COMPLETE
  }
  case object UPDATE_FAILED extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_FAILED
  }
  case object UPDATE_ROLLBACK_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_IN_PROGRESS
  }
  case object UPDATE_ROLLBACK_FAILED
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_FAILED
  }
  case object UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS
  }
  case object UPDATE_ROLLBACK_COMPLETE
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.UPDATE_ROLLBACK_COMPLETE
  }
  case object REVIEW_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.REVIEW_IN_PROGRESS
  }
  case object IMPORT_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_IN_PROGRESS
  }
  case object IMPORT_COMPLETE extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_COMPLETE
  }
  case object IMPORT_ROLLBACK_IN_PROGRESS
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_ROLLBACK_IN_PROGRESS
  }
  case object IMPORT_ROLLBACK_FAILED
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_ROLLBACK_FAILED
  }
  case object IMPORT_ROLLBACK_COMPLETE
      extends zio.aws.cloudformation.model.StackStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackStatus =
      software.amazon.awssdk.services.cloudformation.model.StackStatus.IMPORT_ROLLBACK_COMPLETE
  }
}
