package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{ChangeSetNameOrId, StackName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTemplateRequest(
    stackName: Optional[StackName] = Optional.Absent,
    changeSetName: Optional[ChangeSetNameOrId] = Optional.Absent,
    templateStage: Optional[zio.aws.cloudformation.model.TemplateStage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest = {
    import GetTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        changeSetName.map(value =>
          ChangeSetNameOrId.unwrap(value): java.lang.String
        )
      )(_.changeSetName)
      .optionallyWith(templateStage.map(value => value.unwrap))(_.templateStage)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.GetTemplateRequest.ReadOnly =
    zio.aws.cloudformation.model.GetTemplateRequest.wrap(buildAwsValue())
}
object GetTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetTemplateRequest =
      zio.aws.cloudformation.model.GetTemplateRequest(
        stackName.map(value => value),
        changeSetName.map(value => value),
        templateStage.map(value => value)
      )
    def stackName: Optional[StackName]
    def changeSetName: Optional[ChangeSetNameOrId]
    def templateStage: Optional[zio.aws.cloudformation.model.TemplateStage]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getChangeSetName: ZIO[Any, AwsError, ChangeSetNameOrId] =
      AwsError.unwrapOptionField("changeSetName", changeSetName)
    def getTemplateStage
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.TemplateStage] =
      AwsError.unwrapOptionField("templateStage", templateStage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest
  ) extends zio.aws.cloudformation.model.GetTemplateRequest.ReadOnly {
    override val stackName: Optional[StackName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val changeSetName: Optional[ChangeSetNameOrId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeSetName())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ChangeSetNameOrId(value)
        )
    override val templateStage
        : Optional[zio.aws.cloudformation.model.TemplateStage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateStage())
        .map(value => zio.aws.cloudformation.model.TemplateStage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest
  ): zio.aws.cloudformation.model.GetTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
