package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeName,
  TypeConfigurationAlias,
  TypeConfiguration,
  TypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetTypeConfigurationRequest(
    typeArn: Optional[TypeArn] = Optional.Absent,
    configuration: TypeConfiguration,
    configurationAlias: Optional[TypeConfigurationAlias] = Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest = {
    import SetTypeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest
      .builder()
      .optionallyWith(
        typeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeArn)
      .configuration(TypeConfiguration.unwrap(configuration): java.lang.String)
      .optionallyWith(
        configurationAlias.map(value =>
          TypeConfigurationAlias.unwrap(value): java.lang.String
        )
      )(_.configurationAlias)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.SetTypeConfigurationRequest.ReadOnly =
    zio.aws.cloudformation.model.SetTypeConfigurationRequest
      .wrap(buildAwsValue())
}
object SetTypeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.SetTypeConfigurationRequest =
      zio.aws.cloudformation.model.SetTypeConfigurationRequest(
        typeArn.map(value => value),
        configuration,
        configurationAlias.map(value => value),
        typeName.map(value => value),
        `type`.map(value => value)
      )
    def typeArn: Optional[TypeArn]
    def configuration: TypeConfiguration
    def configurationAlias: Optional[TypeConfigurationAlias]
    def typeName: Optional[TypeName]
    def `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType]
    def getTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeArn", typeArn)
    def getConfiguration: ZIO[Any, Nothing, TypeConfiguration] =
      ZIO.succeed(configuration)
    def getConfigurationAlias: ZIO[Any, AwsError, TypeConfigurationAlias] =
      AwsError.unwrapOptionField("configurationAlias", configurationAlias)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest
  ) extends zio.aws.cloudformation.model.SetTypeConfigurationRequest.ReadOnly {
    override val typeArn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.typeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val configuration: TypeConfiguration =
      zio.aws.cloudformation.model.primitives
        .TypeConfiguration(impl.configuration())
    override val configurationAlias: Optional[TypeConfigurationAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationAlias())
        .map(value =>
          zio.aws.cloudformation.model.primitives.TypeConfigurationAlias(value)
        )
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val `type`: Optional[zio.aws.cloudformation.model.ThirdPartyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest
  ): zio.aws.cloudformation.model.SetTypeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
