package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus
}
object ExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ExecutionStatus
  ): zio.aws.cloudformation.model.ExecutionStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
    case software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.EXECUTE_IN_PROGRESS =>
      val r = EXECUTE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.EXECUTE_COMPLETE =>
      val r = EXECUTE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.EXECUTE_FAILED =>
      val r = EXECUTE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.OBSOLETE =>
      val r = OBSOLETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus =
      software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UNAVAILABLE extends zio.aws.cloudformation.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus =
      software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.UNAVAILABLE
  }
  case object AVAILABLE extends zio.aws.cloudformation.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus =
      software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.AVAILABLE
  }
  case object EXECUTE_IN_PROGRESS
      extends zio.aws.cloudformation.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus =
      software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.EXECUTE_IN_PROGRESS
  }
  case object EXECUTE_COMPLETE
      extends zio.aws.cloudformation.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus =
      software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.EXECUTE_COMPLETE
  }
  case object EXECUTE_FAILED
      extends zio.aws.cloudformation.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus =
      software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.EXECUTE_FAILED
  }
  case object OBSOLETE extends zio.aws.cloudformation.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ExecutionStatus =
      software.amazon.awssdk.services.cloudformation.model.ExecutionStatus.OBSOLETE
  }
}
