package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{TemplateURL, TemplateBody}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EstimateTemplateCostRequest(
    templateBody: Optional[TemplateBody] = Optional.Absent,
    templateURL: Optional[TemplateURL] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudformation.model.Parameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest = {
    import EstimateTemplateCostRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest
      .builder()
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.EstimateTemplateCostRequest.ReadOnly =
    zio.aws.cloudformation.model.EstimateTemplateCostRequest
      .wrap(buildAwsValue())
}
object EstimateTemplateCostRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.EstimateTemplateCostRequest =
      zio.aws.cloudformation.model.EstimateTemplateCostRequest(
        templateBody.map(value => value),
        templateURL.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def templateBody: Optional[TemplateBody]
    def templateURL: Optional[TemplateURL]
    def parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest
  ) extends zio.aws.cloudformation.model.EstimateTemplateCostRequest.ReadOnly {
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Optional[TemplateURL] = zio.aws.core.internal
      .optionalFromNullable(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest
  ): zio.aws.cloudformation.model.EstimateTemplateCostRequest.ReadOnly =
    new Wrapper(impl)
}
