package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ChangeAction {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.ChangeAction
}
object ChangeAction {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ChangeAction
  ): zio.aws.cloudformation.model.ChangeAction = value match {
    case software.amazon.awssdk.services.cloudformation.model.ChangeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeAction.ADD =>
      val r = Add
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeAction.MODIFY =>
      val r = Modify
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeAction.REMOVE =>
      val r = Remove
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeAction.IMPORT =>
      val r = Import
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeAction.DYNAMIC =>
      val r = Dynamic
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeAction =
      software.amazon.awssdk.services.cloudformation.model.ChangeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object Add extends zio.aws.cloudformation.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeAction =
      software.amazon.awssdk.services.cloudformation.model.ChangeAction.ADD
  }
  case object Modify extends zio.aws.cloudformation.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeAction =
      software.amazon.awssdk.services.cloudformation.model.ChangeAction.MODIFY
  }
  case object Remove extends zio.aws.cloudformation.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeAction =
      software.amazon.awssdk.services.cloudformation.model.ChangeAction.REMOVE
  }
  case object Import extends zio.aws.cloudformation.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeAction =
      software.amazon.awssdk.services.cloudformation.model.ChangeAction.IMPORT
  }
  case object Dynamic extends zio.aws.cloudformation.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeAction =
      software.amazon.awssdk.services.cloudformation.model.ChangeAction.DYNAMIC
  }
}
