package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  PublisherId,
  RoleArn,
  TypeSchema,
  PublicVersionNumber,
  OptionalSecureUrl,
  TypeArn,
  Timestamp,
  AutoUpdate,
  IsDefaultVersion,
  IsActivated,
  Description,
  TypeName,
  TypeTestsStatusDescription,
  ConfigurationSchema
}
import scala.jdk.CollectionConverters._
final case class DescribeTypeResponse(
    arn: Optional[TypeArn] = Optional.Absent,
    `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    defaultVersionId: Optional[TypeVersionId] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent,
    typeTestsStatus: Optional[zio.aws.cloudformation.model.TypeTestsStatus] =
      Optional.Absent,
    typeTestsStatusDescription: Optional[TypeTestsStatusDescription] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    schema: Optional[TypeSchema] = Optional.Absent,
    provisioningType: Optional[zio.aws.cloudformation.model.ProvisioningType] =
      Optional.Absent,
    deprecatedStatus: Optional[zio.aws.cloudformation.model.DeprecatedStatus] =
      Optional.Absent,
    loggingConfig: Optional[zio.aws.cloudformation.model.LoggingConfig] =
      Optional.Absent,
    requiredActivatedTypes: Optional[
      Iterable[zio.aws.cloudformation.model.RequiredActivatedType]
    ] = Optional.Absent,
    executionRoleArn: Optional[RoleArn] = Optional.Absent,
    visibility: Optional[zio.aws.cloudformation.model.Visibility] =
      Optional.Absent,
    sourceUrl: Optional[OptionalSecureUrl] = Optional.Absent,
    documentationUrl: Optional[OptionalSecureUrl] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent,
    timeCreated: Optional[Timestamp] = Optional.Absent,
    configurationSchema: Optional[ConfigurationSchema] = Optional.Absent,
    publisherId: Optional[PublisherId] = Optional.Absent,
    originalTypeName: Optional[TypeName] = Optional.Absent,
    originalTypeArn: Optional[TypeArn] = Optional.Absent,
    publicVersionNumber: Optional[PublicVersionNumber] = Optional.Absent,
    latestPublicVersion: Optional[PublicVersionNumber] = Optional.Absent,
    isActivated: Optional[IsActivated] = Optional.Absent,
    autoUpdate: Optional[AutoUpdate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse = {
    import DescribeTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
      .builder()
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        defaultVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(typeTestsStatus.map(value => value.unwrap))(
        _.typeTestsStatus
      )
      .optionallyWith(
        typeTestsStatusDescription.map(value =>
          TypeTestsStatusDescription.unwrap(value): java.lang.String
        )
      )(_.typeTestsStatusDescription)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        schema.map(value => TypeSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(provisioningType.map(value => value.unwrap))(
        _.provisioningType
      )
      .optionallyWith(deprecatedStatus.map(value => value.unwrap))(
        _.deprecatedStatus
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        requiredActivatedTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requiredActivatedTypes)
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(
        sourceUrl.map(value =>
          OptionalSecureUrl.unwrap(value): java.lang.String
        )
      )(_.sourceUrl)
      .optionallyWith(
        documentationUrl.map(value =>
          OptionalSecureUrl.unwrap(value): java.lang.String
        )
      )(_.documentationUrl)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        timeCreated.map(value => Timestamp.unwrap(value): Instant)
      )(_.timeCreated)
      .optionallyWith(
        configurationSchema.map(value =>
          ConfigurationSchema.unwrap(value): java.lang.String
        )
      )(_.configurationSchema)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        originalTypeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.originalTypeName)
      .optionallyWith(
        originalTypeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.originalTypeArn)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .optionallyWith(
        latestPublicVersion.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.latestPublicVersion)
      .optionallyWith(
        isActivated.map(value => IsActivated.unwrap(value): java.lang.Boolean)
      )(_.isActivated)
      .optionallyWith(
        autoUpdate.map(value => AutoUpdate.unwrap(value): java.lang.Boolean)
      )(_.autoUpdate)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeTypeResponse.wrap(buildAwsValue())
}
object DescribeTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeTypeResponse =
      zio.aws.cloudformation.model.DescribeTypeResponse(
        arn.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value),
        defaultVersionId.map(value => value),
        isDefaultVersion.map(value => value),
        typeTestsStatus.map(value => value),
        typeTestsStatusDescription.map(value => value),
        description.map(value => value),
        schema.map(value => value),
        provisioningType.map(value => value),
        deprecatedStatus.map(value => value),
        loggingConfig.map(value => value.asEditable),
        requiredActivatedTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionRoleArn.map(value => value),
        visibility.map(value => value),
        sourceUrl.map(value => value),
        documentationUrl.map(value => value),
        lastUpdated.map(value => value),
        timeCreated.map(value => value),
        configurationSchema.map(value => value),
        publisherId.map(value => value),
        originalTypeName.map(value => value),
        originalTypeArn.map(value => value),
        publicVersionNumber.map(value => value),
        latestPublicVersion.map(value => value),
        isActivated.map(value => value),
        autoUpdate.map(value => value)
      )
    def arn: Optional[TypeArn]
    def `type`: Optional[zio.aws.cloudformation.model.RegistryType]
    def typeName: Optional[TypeName]
    def defaultVersionId: Optional[TypeVersionId]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def typeTestsStatus: Optional[zio.aws.cloudformation.model.TypeTestsStatus]
    def typeTestsStatusDescription: Optional[TypeTestsStatusDescription]
    def description: Optional[Description]
    def schema: Optional[TypeSchema]
    def provisioningType
        : Optional[zio.aws.cloudformation.model.ProvisioningType]
    def deprecatedStatus
        : Optional[zio.aws.cloudformation.model.DeprecatedStatus]
    def loggingConfig
        : Optional[zio.aws.cloudformation.model.LoggingConfig.ReadOnly]
    def requiredActivatedTypes: Optional[
      List[zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly]
    ]
    def executionRoleArn: Optional[RoleArn]
    def visibility: Optional[zio.aws.cloudformation.model.Visibility]
    def sourceUrl: Optional[OptionalSecureUrl]
    def documentationUrl: Optional[OptionalSecureUrl]
    def lastUpdated: Optional[Timestamp]
    def timeCreated: Optional[Timestamp]
    def configurationSchema: Optional[ConfigurationSchema]
    def publisherId: Optional[PublisherId]
    def originalTypeName: Optional[TypeName]
    def originalTypeArn: Optional[TypeArn]
    def publicVersionNumber: Optional[PublicVersionNumber]
    def latestPublicVersion: Optional[PublicVersionNumber]
    def isActivated: Optional[IsActivated]
    def autoUpdate: Optional[AutoUpdate]
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getDefaultVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getTypeTestsStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.TypeTestsStatus] =
      AwsError.unwrapOptionField("typeTestsStatus", typeTestsStatus)
    def getTypeTestsStatusDescription
        : ZIO[Any, AwsError, TypeTestsStatusDescription] =
      AwsError.unwrapOptionField(
        "typeTestsStatusDescription",
        typeTestsStatusDescription
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSchema: ZIO[Any, AwsError, TypeSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getProvisioningType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ProvisioningType] =
      AwsError.unwrapOptionField("provisioningType", provisioningType)
    def getDeprecatedStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.DeprecatedStatus] =
      AwsError.unwrapOptionField("deprecatedStatus", deprecatedStatus)
    def getLoggingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.LoggingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getRequiredActivatedTypes: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "requiredActivatedTypes",
      requiredActivatedTypes
    )
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.Visibility] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getSourceUrl: ZIO[Any, AwsError, OptionalSecureUrl] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getDocumentationUrl: ZIO[Any, AwsError, OptionalSecureUrl] =
      AwsError.unwrapOptionField("documentationUrl", documentationUrl)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getTimeCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timeCreated", timeCreated)
    def getConfigurationSchema: ZIO[Any, AwsError, ConfigurationSchema] =
      AwsError.unwrapOptionField("configurationSchema", configurationSchema)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getOriginalTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("originalTypeName", originalTypeName)
    def getOriginalTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("originalTypeArn", originalTypeArn)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
    def getLatestPublicVersion: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("latestPublicVersion", latestPublicVersion)
    def getIsActivated: ZIO[Any, AwsError, IsActivated] =
      AwsError.unwrapOptionField("isActivated", isActivated)
    def getAutoUpdate: ZIO[Any, AwsError, AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
  ) extends zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly {
    override val arn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val defaultVersionId: Optional[TypeVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersionId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.TypeVersionId(value)
        )
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value =>
          zio.aws.cloudformation.model.primitives.IsDefaultVersion(value)
        )
    override val typeTestsStatus
        : Optional[zio.aws.cloudformation.model.TypeTestsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeTestsStatus())
        .map(value => zio.aws.cloudformation.model.TypeTestsStatus.wrap(value))
    override val typeTestsStatusDescription
        : Optional[TypeTestsStatusDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.typeTestsStatusDescription())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .TypeTestsStatusDescription(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val schema: Optional[TypeSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => zio.aws.cloudformation.model.primitives.TypeSchema(value))
    override val provisioningType
        : Optional[zio.aws.cloudformation.model.ProvisioningType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningType())
        .map(value => zio.aws.cloudformation.model.ProvisioningType.wrap(value))
    override val deprecatedStatus
        : Optional[zio.aws.cloudformation.model.DeprecatedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecatedStatus())
        .map(value => zio.aws.cloudformation.model.DeprecatedStatus.wrap(value))
    override val loggingConfig
        : Optional[zio.aws.cloudformation.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfig())
        .map(value => zio.aws.cloudformation.model.LoggingConfig.wrap(value))
    override val requiredActivatedTypes: Optional[
      List[zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredActivatedTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.RequiredActivatedType.wrap(item)
        }.toList
      )
    override val executionRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => zio.aws.cloudformation.model.primitives.RoleArn(value))
    override val visibility: Optional[zio.aws.cloudformation.model.Visibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visibility())
        .map(value => zio.aws.cloudformation.model.Visibility.wrap(value))
    override val sourceUrl: Optional[OptionalSecureUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceUrl())
      .map(value =>
        zio.aws.cloudformation.model.primitives.OptionalSecureUrl(value)
      )
    override val documentationUrl: Optional[OptionalSecureUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentationUrl())
        .map(value =>
          zio.aws.cloudformation.model.primitives.OptionalSecureUrl(value)
        )
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val timeCreated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timeCreated())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val configurationSchema: Optional[ConfigurationSchema] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSchema())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ConfigurationSchema(value)
        )
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val originalTypeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.originalTypeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val originalTypeArn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.originalTypeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val publicVersionNumber: Optional[PublicVersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicVersionNumber())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
        )
    override val latestPublicVersion: Optional[PublicVersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestPublicVersion())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
        )
    override val isActivated: Optional[IsActivated] = zio.aws.core.internal
      .optionalFromNullable(impl.isActivated())
      .map(value => zio.aws.cloudformation.model.primitives.IsActivated(value))
    override val autoUpdate: Optional[AutoUpdate] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpdate())
      .map(value => zio.aws.cloudformation.model.primitives.AutoUpdate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse
  ): zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
