package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  ResourceToSkip,
  RoleARN,
  StackNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContinueUpdateRollbackRequest(
    stackName: StackNameOrId,
    roleARN: Optional[RoleARN] = Optional.Absent,
    resourcesToSkip: Optional[Iterable[ResourceToSkip]] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest = {
    import ContinueUpdateRollbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        resourcesToSkip.map(value =>
          value.map { item =>
            ResourceToSkip.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourcesToSkip)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ContinueUpdateRollbackRequest.ReadOnly =
    zio.aws.cloudformation.model.ContinueUpdateRollbackRequest
      .wrap(buildAwsValue())
}
object ContinueUpdateRollbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ContinueUpdateRollbackRequest =
      zio.aws.cloudformation.model.ContinueUpdateRollbackRequest(
        stackName,
        roleARN.map(value => value),
        resourcesToSkip.map(value => value),
        clientRequestToken.map(value => value)
      )
    def stackName: StackNameOrId
    def roleARN: Optional[RoleARN]
    def resourcesToSkip: Optional[List[ResourceToSkip]]
    def clientRequestToken: Optional[ClientRequestToken]
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getResourcesToSkip: ZIO[Any, AwsError, List[ResourceToSkip]] =
      AwsError.unwrapOptionField("resourcesToSkip", resourcesToSkip)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest
  ) extends zio.aws.cloudformation.model.ContinueUpdateRollbackRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val resourcesToSkip: Optional[List[ResourceToSkip]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcesToSkip())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.ResourceToSkip(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest
  ): zio.aws.cloudformation.model.ContinueUpdateRollbackRequest.ReadOnly =
    new Wrapper(impl)
}
