package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  SupportedMajorVersion,
  PublisherId,
  TypeName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RequiredActivatedType(
    typeNameAlias: Optional[TypeName] = Optional.Absent,
    originalTypeName: Optional[TypeName] = Optional.Absent,
    publisherId: Optional[PublisherId] = Optional.Absent,
    supportedMajorVersions: Optional[Iterable[SupportedMajorVersion]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType = {
    import RequiredActivatedType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
      .builder()
      .optionallyWith(
        typeNameAlias.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeNameAlias)
      .optionallyWith(
        originalTypeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.originalTypeName)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        supportedMajorVersions.map(value =>
          value.map { item =>
            SupportedMajorVersion.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.supportedMajorVersions)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly =
    zio.aws.cloudformation.model.RequiredActivatedType.wrap(buildAwsValue())
}
object RequiredActivatedType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RequiredActivatedType =
      zio.aws.cloudformation.model.RequiredActivatedType(
        typeNameAlias.map(value => value),
        originalTypeName.map(value => value),
        publisherId.map(value => value),
        supportedMajorVersions.map(value => value)
      )
    def typeNameAlias: Optional[TypeName]
    def originalTypeName: Optional[TypeName]
    def publisherId: Optional[PublisherId]
    def supportedMajorVersions: Optional[List[SupportedMajorVersion]]
    def getTypeNameAlias: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeNameAlias", typeNameAlias)
    def getOriginalTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("originalTypeName", originalTypeName)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getSupportedMajorVersions
        : ZIO[Any, AwsError, List[SupportedMajorVersion]] = AwsError
      .unwrapOptionField("supportedMajorVersions", supportedMajorVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
  ) extends zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly {
    override val typeNameAlias: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeNameAlias())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val originalTypeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.originalTypeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val supportedMajorVersions: Optional[List[SupportedMajorVersion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedMajorVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.SupportedMajorVersion(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType
  ): zio.aws.cloudformation.model.RequiredActivatedType.ReadOnly = new Wrapper(
    impl
  )
}
