package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  StackSetNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectStackSetDriftRequest(
    stackSetName: StackSetNameOrId,
    operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = Optional.Absent,
    operationId: Optional[ClientRequestToken] = Optional.Absent,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest = {
    import DetectStackSetDriftRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
      .builder()
      .stackSetName(StackSetNameOrId.unwrap(stackSetName): java.lang.String)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DetectStackSetDriftRequest.ReadOnly =
    zio.aws.cloudformation.model.DetectStackSetDriftRequest
      .wrap(buildAwsValue())
}
object DetectStackSetDriftRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DetectStackSetDriftRequest =
      zio.aws.cloudformation.model.DetectStackSetDriftRequest(
        stackSetName,
        operationPreferences.map(value => value.asEditable),
        operationId.map(value => value),
        callAs.map(value => value)
      )
    def stackSetName: StackSetNameOrId
    def operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def operationId: Optional[ClientRequestToken]
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetNameOrId] =
      ZIO.succeed(stackSetName)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
  ) extends zio.aws.cloudformation.model.DetectStackSetDriftRequest.ReadOnly {
    override val stackSetName: StackSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .StackSetNameOrId(impl.stackSetName())
    override val operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val operationId: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest
  ): zio.aws.cloudformation.model.DetectStackSetDriftRequest.ReadOnly =
    new Wrapper(impl)
}
