package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  Timestamp,
  StackDriftDetectionId,
  StackId,
  BoxedInteger,
  StackDriftDetectionStatusReason
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStackDriftDetectionStatusResponse(
    stackId: StackId,
    stackDriftDetectionId: StackDriftDetectionId,
    stackDriftStatus: Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      Optional.Absent,
    detectionStatus: zio.aws.cloudformation.model.StackDriftDetectionStatus,
    detectionStatusReason: Optional[StackDriftDetectionStatusReason] =
      Optional.Absent,
    driftedStackResourceCount: Optional[BoxedInteger] = Optional.Absent,
    timestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse = {
    import DescribeStackDriftDetectionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
      .builder()
      .stackId(StackId.unwrap(stackId): java.lang.String)
      .stackDriftDetectionId(
        StackDriftDetectionId.unwrap(stackDriftDetectionId): java.lang.String
      )
      .optionallyWith(stackDriftStatus.map(value => value.unwrap))(
        _.stackDriftStatus
      )
      .detectionStatus(detectionStatus.unwrap)
      .optionallyWith(
        detectionStatusReason.map(value =>
          StackDriftDetectionStatusReason.unwrap(value): java.lang.String
        )
      )(_.detectionStatusReason)
      .optionallyWith(driftedStackResourceCount.map(value => value: Integer))(
        _.driftedStackResourceCount
      )
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse
      .wrap(buildAwsValue())
}
object DescribeStackDriftDetectionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse =
      zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse(
        stackId,
        stackDriftDetectionId,
        stackDriftStatus.map(value => value),
        detectionStatus,
        detectionStatusReason.map(value => value),
        driftedStackResourceCount.map(value => value),
        timestamp
      )
    def stackId: StackId
    def stackDriftDetectionId: StackDriftDetectionId
    def stackDriftStatus
        : Optional[zio.aws.cloudformation.model.StackDriftStatus]
    def detectionStatus: zio.aws.cloudformation.model.StackDriftDetectionStatus
    def detectionStatusReason: Optional[StackDriftDetectionStatusReason]
    def driftedStackResourceCount: Optional[BoxedInteger]
    def timestamp: Timestamp
    def getStackId: ZIO[Any, Nothing, StackId] = ZIO.succeed(stackId)
    def getStackDriftDetectionId: ZIO[Any, Nothing, StackDriftDetectionId] =
      ZIO.succeed(stackDriftDetectionId)
    def getStackDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackDriftStatus] =
      AwsError.unwrapOptionField("stackDriftStatus", stackDriftStatus)
    def getDetectionStatus: ZIO[
      Any,
      Nothing,
      zio.aws.cloudformation.model.StackDriftDetectionStatus
    ] = ZIO.succeed(detectionStatus)
    def getDetectionStatusReason
        : ZIO[Any, AwsError, StackDriftDetectionStatusReason] =
      AwsError.unwrapOptionField("detectionStatusReason", detectionStatusReason)
    def getDriftedStackResourceCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "driftedStackResourceCount",
        driftedStackResourceCount
      )
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
  ) extends zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly {
    override val stackId: StackId =
      zio.aws.cloudformation.model.primitives.StackId(impl.stackId())
    override val stackDriftDetectionId: StackDriftDetectionId =
      zio.aws.cloudformation.model.primitives
        .StackDriftDetectionId(impl.stackDriftDetectionId())
    override val stackDriftStatus
        : Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackDriftStatus())
        .map(value => zio.aws.cloudformation.model.StackDriftStatus.wrap(value))
    override val detectionStatus
        : zio.aws.cloudformation.model.StackDriftDetectionStatus =
      zio.aws.cloudformation.model.StackDriftDetectionStatus
        .wrap(impl.detectionStatus())
    override val detectionStatusReason
        : Optional[StackDriftDetectionStatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.detectionStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .StackDriftDetectionStatusReason(value)
      )
    override val driftedStackResourceCount: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftedStackResourceCount())
        .map(value => value: BoxedInteger)
    override val timestamp: Timestamp =
      zio.aws.cloudformation.model.primitives.Timestamp(impl.timestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
  ): zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
