package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ChangeSetStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus
}
object ChangeSetStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus
  ): zio.aws.cloudformation.model.ChangeSetStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.CREATE_PENDING =>
      val r = CREATE_PENDING
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_PENDING =>
      val r = DELETE_PENDING
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_COMPLETE =>
      val r = DELETE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_PENDING
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.CREATE_PENDING
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_COMPLETE
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.CREATE_COMPLETE
  }
  case object DELETE_PENDING
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_PENDING
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_COMPLETE
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_COMPLETE
  }
  case object DELETE_FAILED
      extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.DELETE_FAILED
  }
  case object FAILED extends zio.aws.cloudformation.model.ChangeSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus =
      software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus.FAILED
  }
}
