package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait Capability {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.Capability
}
object Capability {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.Capability
  ): zio.aws.cloudformation.model.Capability = value match {
    case software.amazon.awssdk.services.cloudformation.model.Capability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.Capability.CAPABILITY_IAM =>
      val r = CAPABILITY_IAM
      r
    case software.amazon.awssdk.services.cloudformation.model.Capability.CAPABILITY_NAMED_IAM =>
      val r = CAPABILITY_NAMED_IAM
      r
    case software.amazon.awssdk.services.cloudformation.model.Capability.CAPABILITY_AUTO_EXPAND =>
      val r = CAPABILITY_AUTO_EXPAND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Capability =
      software.amazon.awssdk.services.cloudformation.model.Capability.UNKNOWN_TO_SDK_VERSION
  }
  case object CAPABILITY_IAM extends zio.aws.cloudformation.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Capability =
      software.amazon.awssdk.services.cloudformation.model.Capability.CAPABILITY_IAM
  }
  case object CAPABILITY_NAMED_IAM
      extends zio.aws.cloudformation.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Capability =
      software.amazon.awssdk.services.cloudformation.model.Capability.CAPABILITY_NAMED_IAM
  }
  case object CAPABILITY_AUTO_EXPAND
      extends zio.aws.cloudformation.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.Capability =
      software.amazon.awssdk.services.cloudformation.model.Capability.CAPABILITY_AUTO_EXPAND
  }
}
