package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait DifferenceType {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.DifferenceType
}
object DifferenceType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.DifferenceType
  ): zio.aws.cloudformation.model.DifferenceType = value match {
    case software.amazon.awssdk.services.cloudformation.model.DifferenceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.DifferenceType.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.cloudformation.model.DifferenceType.REMOVE =>
      val r = REMOVE
      r
    case software.amazon.awssdk.services.cloudformation.model.DifferenceType.NOT_EQUAL =>
      val r = NOT_EQUAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.DifferenceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.DifferenceType =
      software.amazon.awssdk.services.cloudformation.model.DifferenceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends zio.aws.cloudformation.model.DifferenceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.DifferenceType =
      software.amazon.awssdk.services.cloudformation.model.DifferenceType.ADD
  }
  case object REMOVE extends zio.aws.cloudformation.model.DifferenceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.DifferenceType =
      software.amazon.awssdk.services.cloudformation.model.DifferenceType.REMOVE
  }
  case object NOT_EQUAL extends zio.aws.cloudformation.model.DifferenceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.DifferenceType =
      software.amazon.awssdk.services.cloudformation.model.DifferenceType.NOT_EQUAL
  }
}
