package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  OrganizationalUnitId,
  AccountsUrl,
  Account
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeploymentTargets(
    accounts: Optional[Iterable[Account]] = Optional.Absent,
    accountsUrl: Optional[AccountsUrl] = Optional.Absent,
    organizationalUnitIds: Optional[Iterable[OrganizationalUnitId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeploymentTargets = {
    import DeploymentTargets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeploymentTargets
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        accountsUrl.map(value => AccountsUrl.unwrap(value): java.lang.String)
      )(_.accountsUrl)
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DeploymentTargets.ReadOnly =
    zio.aws.cloudformation.model.DeploymentTargets.wrap(buildAwsValue())
}
object DeploymentTargets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeploymentTargets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeploymentTargets =
      zio.aws.cloudformation.model.DeploymentTargets(
        accounts.map(value => value),
        accountsUrl.map(value => value),
        organizationalUnitIds.map(value => value)
      )
    def accounts: Optional[List[Account]]
    def accountsUrl: Optional[AccountsUrl]
    def organizationalUnitIds: Optional[List[OrganizationalUnitId]]
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getAccountsUrl: ZIO[Any, AwsError, AccountsUrl] =
      AwsError.unwrapOptionField("accountsUrl", accountsUrl)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeploymentTargets
  ) extends zio.aws.cloudformation.model.DeploymentTargets.ReadOnly {
    override val accounts: Optional[List[Account]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Account(item)
        }.toList
      )
    override val accountsUrl: Optional[AccountsUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.accountsUrl())
      .map(value => zio.aws.cloudformation.model.primitives.AccountsUrl(value))
    override val organizationalUnitIds: Optional[List[OrganizationalUnitId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeploymentTargets
  ): zio.aws.cloudformation.model.DeploymentTargets.ReadOnly = new Wrapper(impl)
}
