package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  StackName,
  Timestamp,
  StackId,
  ResourceStatusReason,
  PhysicalResourceId,
  ResourceType,
  Description,
  Metadata
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackResourceDetail(
    stackName: Option[StackName] = None,
    stackId: Option[StackId] = None,
    logicalResourceId: LogicalResourceId,
    physicalResourceId: Option[PhysicalResourceId] = None,
    resourceType: ResourceType,
    lastUpdatedTimestamp: Timestamp,
    resourceStatus: zio.aws.cloudformation.model.ResourceStatus,
    resourceStatusReason: Option[ResourceStatusReason] = None,
    description: Option[Description] = None,
    metadata: Option[Metadata] = None,
    driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformation
    ] = None,
    moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackResourceDetail = {
    import StackResourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackResourceDetail
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .lastUpdatedTimestamp(Timestamp.unwrap(lastUpdatedTimestamp): Instant)
      .resourceStatus(resourceStatus.unwrap)
      .optionallyWith(
        resourceStatusReason.map(value =>
          ResourceStatusReason.unwrap(value): java.lang.String
        )
      )(_.resourceStatusReason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .optionallyWith(moduleInfo.map(value => value.buildAwsValue()))(
        _.moduleInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackResourceDetail.ReadOnly =
    zio.aws.cloudformation.model.StackResourceDetail.wrap(buildAwsValue())
}
object StackResourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackResourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackResourceDetail =
      zio.aws.cloudformation.model.StackResourceDetail(
        stackName.map(value => value),
        stackId.map(value => value),
        logicalResourceId,
        physicalResourceId.map(value => value),
        resourceType,
        lastUpdatedTimestamp,
        resourceStatus,
        resourceStatusReason.map(value => value),
        description.map(value => value),
        metadata.map(value => value),
        driftInformation.map(value => value.asEditable),
        moduleInfo.map(value => value.asEditable)
      )
    def stackName: Option[StackName]
    def stackId: Option[StackId]
    def logicalResourceId: LogicalResourceId
    def physicalResourceId: Option[PhysicalResourceId]
    def resourceType: ResourceType
    def lastUpdatedTimestamp: Timestamp
    def resourceStatus: zio.aws.cloudformation.model.ResourceStatus
    def resourceStatusReason: Option[ResourceStatusReason]
    def description: Option[Description]
    def metadata: Option[Metadata]
    def driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ]
    def moduleInfo: Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getLastUpdatedTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTimestamp)
    def getResourceStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.ResourceStatus] =
      ZIO.succeed(resourceStatus)
    def getResourceStatusReason: ZIO[Any, AwsError, ResourceStatusReason] =
      AwsError.unwrapOptionField("resourceStatusReason", resourceStatusReason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
    def getModuleInfo
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ModuleInfo.ReadOnly] =
      AwsError.unwrapOptionField("moduleInfo", moduleInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceDetail
  ) extends zio.aws.cloudformation.model.StackResourceDetail.ReadOnly {
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
      )
    override val resourceType: ResourceType =
      zio.aws.cloudformation.model.primitives.ResourceType(impl.resourceType())
    override val lastUpdatedTimestamp: Timestamp =
      zio.aws.cloudformation.model.primitives
        .Timestamp(impl.lastUpdatedTimestamp())
    override val resourceStatus: zio.aws.cloudformation.model.ResourceStatus =
      zio.aws.cloudformation.model.ResourceStatus.wrap(impl.resourceStatus())
    override val resourceStatusReason: Option[ResourceStatusReason] = scala
      .Option(impl.resourceStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceStatusReason(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.cloudformation.model.primitives.Metadata(value))
    override val driftInformation: Option[
      zio.aws.cloudformation.model.StackResourceDriftInformation.ReadOnly
    ] = scala
      .Option(impl.driftInformation())
      .map(value =>
        zio.aws.cloudformation.model.StackResourceDriftInformation.wrap(value)
      )
    override val moduleInfo
        : Option[zio.aws.cloudformation.model.ModuleInfo.ReadOnly] = scala
      .Option(impl.moduleInfo())
      .map(value => zio.aws.cloudformation.model.ModuleInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackResourceDetail
  ): zio.aws.cloudformation.model.StackResourceDetail.ReadOnly = new Wrapper(
    impl
  )
}
