package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  StackName,
  ResourceProperties,
  Timestamp,
  ClientRequestToken,
  HookStatusReason,
  EventId,
  StackId,
  ResourceStatusReason,
  PhysicalResourceId,
  ResourceType,
  HookType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackEvent(
    stackId: StackId,
    eventId: EventId,
    stackName: StackName,
    logicalResourceId: Option[LogicalResourceId] = None,
    physicalResourceId: Option[PhysicalResourceId] = None,
    resourceType: Option[ResourceType] = None,
    timestamp: Timestamp,
    resourceStatus: Option[zio.aws.cloudformation.model.ResourceStatus] = None,
    resourceStatusReason: Option[ResourceStatusReason] = None,
    resourceProperties: Option[ResourceProperties] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    hookType: Option[HookType] = None,
    hookStatus: Option[zio.aws.cloudformation.model.HookStatus] = None,
    hookStatusReason: Option[HookStatusReason] = None,
    hookInvocationPoint: Option[
      zio.aws.cloudformation.model.HookInvocationPoint
    ] = None,
    hookFailureMode: Option[zio.aws.cloudformation.model.HookFailureMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackEvent = {
    import StackEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackEvent
      .builder()
      .stackId(StackId.unwrap(stackId): java.lang.String)
      .eventId(EventId.unwrap(eventId): java.lang.String)
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .optionallyWith(resourceStatus.map(value => value.unwrap))(
        _.resourceStatus
      )
      .optionallyWith(
        resourceStatusReason.map(value =>
          ResourceStatusReason.unwrap(value): java.lang.String
        )
      )(_.resourceStatusReason)
      .optionallyWith(
        resourceProperties.map(value =>
          ResourceProperties.unwrap(value): java.lang.String
        )
      )(_.resourceProperties)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        hookType.map(value => HookType.unwrap(value): java.lang.String)
      )(_.hookType)
      .optionallyWith(hookStatus.map(value => value.unwrap))(_.hookStatus)
      .optionallyWith(
        hookStatusReason.map(value =>
          HookStatusReason.unwrap(value): java.lang.String
        )
      )(_.hookStatusReason)
      .optionallyWith(hookInvocationPoint.map(value => value.unwrap))(
        _.hookInvocationPoint
      )
      .optionallyWith(hookFailureMode.map(value => value.unwrap))(
        _.hookFailureMode
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackEvent.ReadOnly =
    zio.aws.cloudformation.model.StackEvent.wrap(buildAwsValue())
}
object StackEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackEvent =
      zio.aws.cloudformation.model.StackEvent(
        stackId,
        eventId,
        stackName,
        logicalResourceId.map(value => value),
        physicalResourceId.map(value => value),
        resourceType.map(value => value),
        timestamp,
        resourceStatus.map(value => value),
        resourceStatusReason.map(value => value),
        resourceProperties.map(value => value),
        clientRequestToken.map(value => value),
        hookType.map(value => value),
        hookStatus.map(value => value),
        hookStatusReason.map(value => value),
        hookInvocationPoint.map(value => value),
        hookFailureMode.map(value => value)
      )
    def stackId: StackId
    def eventId: EventId
    def stackName: StackName
    def logicalResourceId: Option[LogicalResourceId]
    def physicalResourceId: Option[PhysicalResourceId]
    def resourceType: Option[ResourceType]
    def timestamp: Timestamp
    def resourceStatus: Option[zio.aws.cloudformation.model.ResourceStatus]
    def resourceStatusReason: Option[ResourceStatusReason]
    def resourceProperties: Option[ResourceProperties]
    def clientRequestToken: Option[ClientRequestToken]
    def hookType: Option[HookType]
    def hookStatus: Option[zio.aws.cloudformation.model.HookStatus]
    def hookStatusReason: Option[HookStatusReason]
    def hookInvocationPoint
        : Option[zio.aws.cloudformation.model.HookInvocationPoint]
    def hookFailureMode: Option[zio.aws.cloudformation.model.HookFailureMode]
    def getStackId: ZIO[Any, Nothing, StackId] = ZIO.succeed(stackId)
    def getEventId: ZIO[Any, Nothing, EventId] = ZIO.succeed(eventId)
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getResourceStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ResourceStatus] =
      AwsError.unwrapOptionField("resourceStatus", resourceStatus)
    def getResourceStatusReason: ZIO[Any, AwsError, ResourceStatusReason] =
      AwsError.unwrapOptionField("resourceStatusReason", resourceStatusReason)
    def getResourceProperties: ZIO[Any, AwsError, ResourceProperties] =
      AwsError.unwrapOptionField("resourceProperties", resourceProperties)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getHookType: ZIO[Any, AwsError, HookType] =
      AwsError.unwrapOptionField("hookType", hookType)
    def getHookStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HookStatus] =
      AwsError.unwrapOptionField("hookStatus", hookStatus)
    def getHookStatusReason: ZIO[Any, AwsError, HookStatusReason] =
      AwsError.unwrapOptionField("hookStatusReason", hookStatusReason)
    def getHookInvocationPoint
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HookInvocationPoint] =
      AwsError.unwrapOptionField("hookInvocationPoint", hookInvocationPoint)
    def getHookFailureMode
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HookFailureMode] =
      AwsError.unwrapOptionField("hookFailureMode", hookFailureMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackEvent
  ) extends zio.aws.cloudformation.model.StackEvent.ReadOnly {
    override val stackId: StackId =
      zio.aws.cloudformation.model.primitives.StackId(impl.stackId())
    override val eventId: EventId =
      zio.aws.cloudformation.model.primitives.EventId(impl.eventId())
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val logicalResourceId: Option[LogicalResourceId] = scala
      .Option(impl.logicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LogicalResourceId(value)
      )
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
      )
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.cloudformation.model.primitives.ResourceType(value))
    override val timestamp: Timestamp =
      zio.aws.cloudformation.model.primitives.Timestamp(impl.timestamp())
    override val resourceStatus
        : Option[zio.aws.cloudformation.model.ResourceStatus] = scala
      .Option(impl.resourceStatus())
      .map(value => zio.aws.cloudformation.model.ResourceStatus.wrap(value))
    override val resourceStatusReason: Option[ResourceStatusReason] = scala
      .Option(impl.resourceStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceStatusReason(value)
      )
    override val resourceProperties: Option[ResourceProperties] = scala
      .Option(impl.resourceProperties())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceProperties(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val hookType: Option[HookType] = scala
      .Option(impl.hookType())
      .map(value => zio.aws.cloudformation.model.primitives.HookType(value))
    override val hookStatus: Option[zio.aws.cloudformation.model.HookStatus] =
      scala
        .Option(impl.hookStatus())
        .map(value => zio.aws.cloudformation.model.HookStatus.wrap(value))
    override val hookStatusReason: Option[HookStatusReason] = scala
      .Option(impl.hookStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.HookStatusReason(value)
      )
    override val hookInvocationPoint
        : Option[zio.aws.cloudformation.model.HookInvocationPoint] = scala
      .Option(impl.hookInvocationPoint())
      .map(value =>
        zio.aws.cloudformation.model.HookInvocationPoint.wrap(value)
      )
    override val hookFailureMode
        : Option[zio.aws.cloudformation.model.HookFailureMode] = scala
      .Option(impl.hookFailureMode())
      .map(value => zio.aws.cloudformation.model.HookFailureMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackEvent
  ): zio.aws.cloudformation.model.StackEvent.ReadOnly = new Wrapper(impl)
}
