package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackDriftInformationSummary(
    stackDriftStatus: zio.aws.cloudformation.model.StackDriftStatus,
    lastCheckTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackDriftInformationSummary = {
    import StackDriftInformationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackDriftInformationSummary
      .builder()
      .stackDriftStatus(stackDriftStatus.unwrap)
      .optionallyWith(
        lastCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastCheckTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly =
    zio.aws.cloudformation.model.StackDriftInformationSummary
      .wrap(buildAwsValue())
}
object StackDriftInformationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackDriftInformationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackDriftInformationSummary =
      zio.aws.cloudformation.model.StackDriftInformationSummary(
        stackDriftStatus,
        lastCheckTimestamp.map(value => value)
      )
    def stackDriftStatus: zio.aws.cloudformation.model.StackDriftStatus
    def lastCheckTimestamp: Option[Timestamp]
    def getStackDriftStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.StackDriftStatus] =
      ZIO.succeed(stackDriftStatus)
    def getLastCheckTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastCheckTimestamp", lastCheckTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackDriftInformationSummary
  ) extends zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly {
    override val stackDriftStatus
        : zio.aws.cloudformation.model.StackDriftStatus =
      zio.aws.cloudformation.model.StackDriftStatus
        .wrap(impl.stackDriftStatus())
    override val lastCheckTimestamp: Option[Timestamp] = scala
      .Option(impl.lastCheckTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackDriftInformationSummary
  ): zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly =
    new Wrapper(impl)
}
