package zio.aws.cloudformation.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  CreationTime,
  DisableRollback,
  StackName,
  NotificationARN,
  DeletionTime,
  StackId,
  RoleARN,
  Description,
  EnableTerminationProtection,
  ChangeSetId,
  TimeoutMinutes,
  LastUpdatedTime,
  StackStatusReason
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Stack(
    stackId: Option[StackId] = None,
    stackName: StackName,
    changeSetId: Option[ChangeSetId] = None,
    description: Option[Description] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    creationTime: CreationTime,
    deletionTime: Option[DeletionTime] = None,
    lastUpdatedTime: Option[LastUpdatedTime] = None,
    rollbackConfiguration: Option[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = None,
    stackStatus: zio.aws.cloudformation.model.StackStatus,
    stackStatusReason: Option[StackStatusReason] = None,
    disableRollback: Option[DisableRollback] = None,
    notificationARNs: Option[Iterable[NotificationARN]] = None,
    timeoutInMinutes: Option[TimeoutMinutes] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    outputs: Option[Iterable[zio.aws.cloudformation.model.Output]] = None,
    roleARN: Option[RoleARN] = None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    enableTerminationProtection: Option[EnableTerminationProtection] = None,
    parentId: Option[StackId] = None,
    rootId: Option[StackId] = None,
    driftInformation: Option[
      zio.aws.cloudformation.model.StackDriftInformation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Stack = {
    import Stack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Stack
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        changeSetId.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        deletionTime.map(value => DeletionTime.unwrap(value): Instant)
      )(_.deletionTime)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .stackStatus(stackStatus.unwrap)
      .optionallyWith(
        stackStatusReason.map(value =>
          StackStatusReason.unwrap(value): java.lang.String
        )
      )(_.stackStatusReason)
      .optionallyWith(
        disableRollback.map(value =>
          DisableRollback.unwrap(value): java.lang.Boolean
        )
      )(_.disableRollback)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        timeoutInMinutes.map(value => TimeoutMinutes.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableTerminationProtection.map(value =>
          EnableTerminationProtection.unwrap(value): java.lang.Boolean
        )
      )(_.enableTerminationProtection)
      .optionallyWith(
        parentId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.parentId)
      .optionallyWith(
        rootId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.rootId)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Stack.ReadOnly =
    zio.aws.cloudformation.model.Stack.wrap(buildAwsValue())
}
object Stack {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Stack
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Stack =
      zio.aws.cloudformation.model.Stack(
        stackId.map(value => value),
        stackName,
        changeSetId.map(value => value),
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime,
        deletionTime.map(value => value),
        lastUpdatedTime.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        stackStatus,
        stackStatusReason.map(value => value),
        disableRollback.map(value => value),
        notificationARNs.map(value => value),
        timeoutInMinutes.map(value => value),
        capabilities.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleARN.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableTerminationProtection.map(value => value),
        parentId.map(value => value),
        rootId.map(value => value),
        driftInformation.map(value => value.asEditable)
      )
    def stackId: Option[StackId]
    def stackName: StackName
    def changeSetId: Option[ChangeSetId]
    def description: Option[Description]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def creationTime: CreationTime
    def deletionTime: Option[DeletionTime]
    def lastUpdatedTime: Option[LastUpdatedTime]
    def rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def stackStatus: zio.aws.cloudformation.model.StackStatus
    def stackStatusReason: Option[StackStatusReason]
    def disableRollback: Option[DisableRollback]
    def notificationARNs: Option[List[NotificationARN]]
    def timeoutInMinutes: Option[TimeoutMinutes]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def outputs: Option[List[zio.aws.cloudformation.model.Output.ReadOnly]]
    def roleARN: Option[RoleARN]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def enableTerminationProtection: Option[EnableTerminationProtection]
    def parentId: Option[StackId]
    def rootId: Option[StackId]
    def driftInformation
        : Option[zio.aws.cloudformation.model.StackDriftInformation.ReadOnly]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getDeletionTime: ZIO[Any, AwsError, DeletionTime] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getStackStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.StackStatus] =
      ZIO.succeed(stackStatus)
    def getStackStatusReason: ZIO[Any, AwsError, StackStatusReason] =
      AwsError.unwrapOptionField("stackStatusReason", stackStatusReason)
    def getDisableRollback: ZIO[Any, AwsError, DisableRollback] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getTimeoutInMinutes: ZIO[Any, AwsError, TimeoutMinutes] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Output.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableTerminationProtection
        : ZIO[Any, AwsError, EnableTerminationProtection] =
      AwsError.unwrapOptionField(
        "enableTerminationProtection",
        enableTerminationProtection
      )
    def getParentId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getRootId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("rootId", rootId)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackDriftInformation.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Stack
  ) extends zio.aws.cloudformation.model.Stack.ReadOnly {
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val changeSetId: Option[ChangeSetId] = scala
      .Option(impl.changeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val creationTime: CreationTime =
      zio.aws.cloudformation.model.primitives.CreationTime(impl.creationTime())
    override val deletionTime: Option[DeletionTime] = scala
      .Option(impl.deletionTime())
      .map(value => zio.aws.cloudformation.model.primitives.DeletionTime(value))
    override val lastUpdatedTime: Option[LastUpdatedTime] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LastUpdatedTime(value)
      )
    override val rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly] =
      scala
        .Option(impl.rollbackConfiguration())
        .map(value =>
          zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
        )
    override val stackStatus: zio.aws.cloudformation.model.StackStatus =
      zio.aws.cloudformation.model.StackStatus.wrap(impl.stackStatus())
    override val stackStatusReason: Option[StackStatusReason] = scala
      .Option(impl.stackStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackStatusReason(value)
      )
    override val disableRollback: Option[DisableRollback] = scala
      .Option(impl.disableRollback())
      .map(value =>
        zio.aws.cloudformation.model.primitives.DisableRollback(value)
      )
    override val notificationARNs: Option[List[NotificationARN]] = scala
      .Option(impl.notificationARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.NotificationARN(item)
        }.toList
      )
    override val timeoutInMinutes: Option[TimeoutMinutes] = scala
      .Option(impl.timeoutInMinutes())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TimeoutMinutes(value)
      )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val outputs
        : Option[List[zio.aws.cloudformation.model.Output.ReadOnly]] = scala
      .Option(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Output.wrap(item)
        }.toList
      )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val enableTerminationProtection
        : Option[EnableTerminationProtection] = scala
      .Option(impl.enableTerminationProtection())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .EnableTerminationProtection(value)
      )
    override val parentId: Option[StackId] = scala
      .Option(impl.parentId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val rootId: Option[StackId] = scala
      .Option(impl.rootId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val driftInformation
        : Option[zio.aws.cloudformation.model.StackDriftInformation.ReadOnly] =
      scala
        .Option(impl.driftInformation())
        .map(value =>
          zio.aws.cloudformation.model.StackDriftInformation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Stack
  ): zio.aws.cloudformation.model.Stack.ReadOnly = new Wrapper(impl)
}
