package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  UsePreviousValue,
  ParameterValue,
  ParameterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Parameter(
    parameterKey: Option[ParameterKey] = None,
    parameterValue: Option[ParameterValue] = None,
    usePreviousValue: Option[UsePreviousValue] = None,
    resolvedValue: Option[ParameterValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Parameter
      .builder()
      .optionallyWith(
        parameterKey.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.parameterKey)
      .optionallyWith(
        parameterValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.parameterValue)
      .optionallyWith(
        usePreviousValue.map(value =>
          UsePreviousValue.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousValue)
      .optionallyWith(
        resolvedValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.resolvedValue)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Parameter.ReadOnly =
    zio.aws.cloudformation.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Parameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Parameter =
      zio.aws.cloudformation.model.Parameter(
        parameterKey.map(value => value),
        parameterValue.map(value => value),
        usePreviousValue.map(value => value),
        resolvedValue.map(value => value)
      )
    def parameterKey: Option[ParameterKey]
    def parameterValue: Option[ParameterValue]
    def usePreviousValue: Option[UsePreviousValue]
    def resolvedValue: Option[ParameterValue]
    def getParameterKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("parameterKey", parameterKey)
    def getParameterValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
    def getUsePreviousValue: ZIO[Any, AwsError, UsePreviousValue] =
      AwsError.unwrapOptionField("usePreviousValue", usePreviousValue)
    def getResolvedValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("resolvedValue", resolvedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Parameter
  ) extends zio.aws.cloudformation.model.Parameter.ReadOnly {
    override val parameterKey: Option[ParameterKey] = scala
      .Option(impl.parameterKey())
      .map(value => zio.aws.cloudformation.model.primitives.ParameterKey(value))
    override val parameterValue: Option[ParameterValue] = scala
      .Option(impl.parameterValue())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterValue(value)
      )
    override val usePreviousValue: Option[UsePreviousValue] = scala
      .Option(impl.usePreviousValue())
      .map(value =>
        zio.aws.cloudformation.model.primitives.UsePreviousValue(value)
      )
    override val resolvedValue: Option[ParameterValue] = scala
      .Option(impl.resolvedValue())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ParameterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Parameter
  ): zio.aws.cloudformation.model.Parameter.ReadOnly = new Wrapper(impl)
}
