package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStackSetResponse(
    stackSet: Option[zio.aws.cloudformation.model.StackSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse = {
    import DescribeStackSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse
      .builder()
      .optionallyWith(stackSet.map(value => value.buildAwsValue()))(_.stackSet)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackSetResponse.wrap(buildAwsValue())
}
object DescribeStackSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackSetResponse =
      zio.aws.cloudformation.model
        .DescribeStackSetResponse(stackSet.map(value => value.asEditable))
    def stackSet: Option[zio.aws.cloudformation.model.StackSet.ReadOnly]
    def getStackSet
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSet.ReadOnly] =
      AwsError.unwrapOptionField("stackSet", stackSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse
  ) extends zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly {
    override val stackSet
        : Option[zio.aws.cloudformation.model.StackSet.ReadOnly] = scala
      .Option(impl.stackSet())
      .map(value => zio.aws.cloudformation.model.StackSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse
  ): zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly =
    new Wrapper(impl)
}
