package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  HookTargetTypeName,
  LogicalResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChangeSetHookResourceTargetDetails(
    logicalResourceId: Option[LogicalResourceId] = None,
    resourceType: Option[HookTargetTypeName] = None,
    resourceAction: Option[zio.aws.cloudformation.model.ChangeAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ChangeSetHookResourceTargetDetails = {
    import ChangeSetHookResourceTargetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHookResourceTargetDetails
      .builder()
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .optionallyWith(
        resourceType.map(value =>
          HookTargetTypeName.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(resourceAction.map(value => value.unwrap))(
        _.resourceAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly =
    zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails
      .wrap(buildAwsValue())
}
object ChangeSetHookResourceTargetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHookResourceTargetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails =
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails(
        logicalResourceId.map(value => value),
        resourceType.map(value => value),
        resourceAction.map(value => value)
      )
    def logicalResourceId: Option[LogicalResourceId]
    def resourceType: Option[HookTargetTypeName]
    def resourceAction: Option[zio.aws.cloudformation.model.ChangeAction]
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
    def getResourceType: ZIO[Any, AwsError, HookTargetTypeName] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceAction
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeAction] =
      AwsError.unwrapOptionField("resourceAction", resourceAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHookResourceTargetDetails
  ) extends zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly {
    override val logicalResourceId: Option[LogicalResourceId] = scala
      .Option(impl.logicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LogicalResourceId(value)
      )
    override val resourceType: Option[HookTargetTypeName] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.cloudformation.model.primitives.HookTargetTypeName(value)
      )
    override val resourceAction
        : Option[zio.aws.cloudformation.model.ChangeAction] = scala
      .Option(impl.resourceAction())
      .map(value => zio.aws.cloudformation.model.ChangeAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHookResourceTargetDetails
  ): zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly =
    new Wrapper(impl)
}
