package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  S3Bucket,
  TypeVersionId,
  TypeName,
  TypeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestTypeRequest(
    arn: Option[TypeArn] = None,
    `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] = None,
    typeName: Option[TypeName] = None,
    versionId: Option[TypeVersionId] = None,
    logDeliveryBucket: Option[S3Bucket] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TestTypeRequest = {
    import TestTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
      .builder()
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        versionId.map(value => TypeVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        logDeliveryBucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.logDeliveryBucket)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TestTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.TestTypeRequest.wrap(buildAwsValue())
}
object TestTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TestTypeRequest =
      zio.aws.cloudformation.model.TestTypeRequest(
        arn.map(value => value),
        `type`.map(value => value),
        typeName.map(value => value),
        versionId.map(value => value),
        logDeliveryBucket.map(value => value)
      )
    def arn: Option[TypeArn]
    def `type`: Option[zio.aws.cloudformation.model.ThirdPartyType]
    def typeName: Option[TypeName]
    def versionId: Option[TypeVersionId]
    def logDeliveryBucket: Option[S3Bucket]
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ThirdPartyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getLogDeliveryBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("logDeliveryBucket", logDeliveryBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
  ) extends zio.aws.cloudformation.model.TestTypeRequest.ReadOnly {
    override val arn: Option[TypeArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val `type`: Option[zio.aws.cloudformation.model.ThirdPartyType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ThirdPartyType.wrap(value))
    override val typeName: Option[TypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val versionId: Option[TypeVersionId] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
    override val logDeliveryBucket: Option[S3Bucket] = scala
      .Option(impl.logDeliveryBucket())
      .map(value => zio.aws.cloudformation.model.primitives.S3Bucket(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TestTypeRequest
  ): zio.aws.cloudformation.model.TestTypeRequest.ReadOnly = new Wrapper(impl)
}
