package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{Timestamp, ClientRequestToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StackSetOperationSummary(
    operationId: Option[ClientRequestToken] = None,
    action: Option[zio.aws.cloudformation.model.StackSetOperationAction] = None,
    status: Option[zio.aws.cloudformation.model.StackSetOperationStatus] = None,
    creationTimestamp: Option[Timestamp] = None,
    endTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary = {
    import StackSetOperationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        endTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly =
    zio.aws.cloudformation.model.StackSetOperationSummary.wrap(buildAwsValue())
}
object StackSetOperationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetOperationSummary =
      zio.aws.cloudformation.model.StackSetOperationSummary(
        operationId.map(value => value),
        action.map(value => value),
        status.map(value => value),
        creationTimestamp.map(value => value),
        endTimestamp.map(value => value)
      )
    def operationId: Option[ClientRequestToken]
    def action: Option[zio.aws.cloudformation.model.StackSetOperationAction]
    def status: Option[zio.aws.cloudformation.model.StackSetOperationStatus]
    def creationTimestamp: Option[Timestamp]
    def endTimestamp: Option[Timestamp]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationAction
    ] = AwsError.unwrapOptionField("action", action)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getEndTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimestamp", endTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
  ) extends zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly {
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val action
        : Option[zio.aws.cloudformation.model.StackSetOperationAction] = scala
      .Option(impl.action())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationAction.wrap(value)
      )
    override val status
        : Option[zio.aws.cloudformation.model.StackSetOperationStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationStatus.wrap(value)
      )
    override val creationTimestamp: Option[Timestamp] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val endTimestamp: Option[Timestamp] = scala
      .Option(impl.endTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
  ): zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly =
    new Wrapper(impl)
}
