package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  StackIdsUrl,
  StackId,
  StackSetNameOrId,
  OrganizationalUnitId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportStacksToStackSetRequest(
    stackSetName: StackSetNameOrId,
    stackIds: Option[Iterable[StackId]] = None,
    stackIdsUrl: Option[StackIdsUrl] = None,
    organizationalUnitIds: Option[Iterable[OrganizationalUnitId]] = None,
    operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = None,
    operationId: Option[ClientRequestToken] = None,
    callAs: Option[zio.aws.cloudformation.model.CallAs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest = {
    import ImportStacksToStackSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest
      .builder()
      .stackSetName(StackSetNameOrId.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        stackIds.map(value =>
          value.map { item =>
            StackId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackIds)
      .optionallyWith(
        stackIdsUrl.map(value => StackIdsUrl.unwrap(value): java.lang.String)
      )(_.stackIdsUrl)
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ImportStacksToStackSetRequest.ReadOnly =
    zio.aws.cloudformation.model.ImportStacksToStackSetRequest
      .wrap(buildAwsValue())
}
object ImportStacksToStackSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ImportStacksToStackSetRequest =
      zio.aws.cloudformation.model.ImportStacksToStackSetRequest(
        stackSetName,
        stackIds.map(value => value),
        stackIdsUrl.map(value => value),
        organizationalUnitIds.map(value => value),
        operationPreferences.map(value => value.asEditable),
        operationId.map(value => value),
        callAs.map(value => value)
      )
    def stackSetName: StackSetNameOrId
    def stackIds: Option[List[StackId]]
    def stackIdsUrl: Option[StackIdsUrl]
    def organizationalUnitIds: Option[List[OrganizationalUnitId]]
    def operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def operationId: Option[ClientRequestToken]
    def callAs: Option[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetNameOrId] =
      ZIO.succeed(stackSetName)
    def getStackIds: ZIO[Any, AwsError, List[StackId]] =
      AwsError.unwrapOptionField("stackIds", stackIds)
    def getStackIdsUrl: ZIO[Any, AwsError, StackIdsUrl] =
      AwsError.unwrapOptionField("stackIdsUrl", stackIdsUrl)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest
  ) extends zio.aws.cloudformation.model.ImportStacksToStackSetRequest.ReadOnly {
    override val stackSetName: StackSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .StackSetNameOrId(impl.stackSetName())
    override val stackIds: Option[List[StackId]] = scala
      .Option(impl.stackIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.StackId(item)
        }.toList
      )
    override val stackIdsUrl: Option[StackIdsUrl] = scala
      .Option(impl.stackIdsUrl())
      .map(value => zio.aws.cloudformation.model.primitives.StackIdsUrl(value))
    override val organizationalUnitIds: Option[List[OrganizationalUnitId]] =
      scala
        .Option(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
    override val operationPreferences: Option[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = scala
      .Option(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val operationId: Option[ClientRequestToken] = scala
      .Option(impl.operationId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val callAs: Option[zio.aws.cloudformation.model.CallAs] = scala
      .Option(impl.callAs())
      .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest
  ): zio.aws.cloudformation.model.ImportStacksToStackSetRequest.ReadOnly =
    new Wrapper(impl)
}
