package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  PhysicalResourceId,
  LogicalResourceId,
  StackName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStackResourcesRequest(
    stackName: Option[StackName] = None,
    logicalResourceId: Option[LogicalResourceId] = None,
    physicalResourceId: Option[PhysicalResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest = {
    import DescribeStackResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackResourcesRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackResourcesRequest
      .wrap(buildAwsValue())
}
object DescribeStackResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackResourcesRequest =
      zio.aws.cloudformation.model.DescribeStackResourcesRequest(
        stackName.map(value => value),
        logicalResourceId.map(value => value),
        physicalResourceId.map(value => value)
      )
    def stackName: Option[StackName]
    def logicalResourceId: Option[LogicalResourceId]
    def physicalResourceId: Option[PhysicalResourceId]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest
  ) extends zio.aws.cloudformation.model.DescribeStackResourcesRequest.ReadOnly {
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val logicalResourceId: Option[LogicalResourceId] = scala
      .Option(impl.logicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.LogicalResourceId(value)
      )
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.PhysicalResourceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest
  ): zio.aws.cloudformation.model.DescribeStackResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
