package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStackEventsResponse(
    stackEvents: Option[Iterable[zio.aws.cloudformation.model.StackEvent]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse = {
    import DescribeStackEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse
      .builder()
      .optionallyWith(
        stackEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackEvents)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackEventsResponse
      .wrap(buildAwsValue())
}
object DescribeStackEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackEventsResponse =
      zio.aws.cloudformation.model.DescribeStackEventsResponse(
        stackEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stackEvents
        : Option[List[zio.aws.cloudformation.model.StackEvent.ReadOnly]]
    def nextToken: Option[NextToken]
    def getStackEvents: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("stackEvents", stackEvents)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse
  ) extends zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly {
    override val stackEvents
        : Option[List[zio.aws.cloudformation.model.StackEvent.ReadOnly]] = scala
      .Option(impl.stackEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackEvent.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse
  ): zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly =
    new Wrapper(impl)
}
