package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackNameOrId,
  ChangeSetNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteChangeSetRequest(
    changeSetName: ChangeSetNameOrId,
    stackName: Option[StackNameOrId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest = {
    import DeleteChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest
      .builder()
      .changeSetName(ChangeSetNameOrId.unwrap(changeSetName): java.lang.String)
      .optionallyWith(
        stackName.map(value => StackNameOrId.unwrap(value): java.lang.String)
      )(_.stackName)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DeleteChangeSetRequest.ReadOnly =
    zio.aws.cloudformation.model.DeleteChangeSetRequest.wrap(buildAwsValue())
}
object DeleteChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DeleteChangeSetRequest =
      zio.aws.cloudformation.model
        .DeleteChangeSetRequest(changeSetName, stackName.map(value => value))
    def changeSetName: ChangeSetNameOrId
    def stackName: Option[StackNameOrId]
    def getChangeSetName: ZIO[Any, Nothing, ChangeSetNameOrId] =
      ZIO.succeed(changeSetName)
    def getStackName: ZIO[Any, AwsError, StackNameOrId] =
      AwsError.unwrapOptionField("stackName", stackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest
  ) extends zio.aws.cloudformation.model.DeleteChangeSetRequest.ReadOnly {
    override val changeSetName: ChangeSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .ChangeSetNameOrId(impl.changeSetName())
    override val stackName: Option[StackNameOrId] = scala
      .Option(impl.stackName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackNameOrId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest
  ): zio.aws.cloudformation.model.DeleteChangeSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
