package zio.aws.cloudformation.model
import java.lang.Integer
import zio.aws.cloudformation.model.primitives.{
  TemplateURL,
  DisableRollback,
  StackName,
  NotificationARN,
  ClientRequestToken,
  StackPolicyBody,
  ResourceType,
  RoleARN,
  EnableTerminationProtection,
  StackPolicyURL,
  TimeoutMinutes,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStackRequest(
    stackName: StackName,
    templateBody: Option[TemplateBody] = None,
    templateURL: Option[TemplateURL] = None,
    parameters: Option[Iterable[zio.aws.cloudformation.model.Parameter]] = None,
    disableRollback: Option[DisableRollback] = None,
    rollbackConfiguration: Option[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = None,
    timeoutInMinutes: Option[TimeoutMinutes] = None,
    notificationARNs: Option[Iterable[NotificationARN]] = None,
    capabilities: Option[Iterable[zio.aws.cloudformation.model.Capability]] =
      None,
    resourceTypes: Option[Iterable[ResourceType]] = None,
    roleARN: Option[RoleARN] = None,
    onFailure: Option[zio.aws.cloudformation.model.OnFailure] = None,
    stackPolicyBody: Option[StackPolicyBody] = None,
    stackPolicyURL: Option[StackPolicyURL] = None,
    tags: Option[Iterable[zio.aws.cloudformation.model.Tag]] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    enableTerminationProtection: Option[EnableTerminationProtection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateStackRequest = {
    import CreateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        disableRollback.map(value =>
          DisableRollback.unwrap(value): java.lang.Boolean
        )
      )(_.disableRollback)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        timeoutInMinutes.map(value => TimeoutMinutes.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(onFailure.map(value => value.unwrap))(_.onFailure)
      .optionallyWith(
        stackPolicyBody.map(value =>
          StackPolicyBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyBody)
      .optionallyWith(
        stackPolicyURL.map(value =>
          StackPolicyURL.unwrap(value): java.lang.String
        )
      )(_.stackPolicyURL)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        enableTerminationProtection.map(value =>
          EnableTerminationProtection.unwrap(value): java.lang.Boolean
        )
      )(_.enableTerminationProtection)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.CreateStackRequest.ReadOnly =
    zio.aws.cloudformation.model.CreateStackRequest.wrap(buildAwsValue())
}
object CreateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateStackRequest =
      zio.aws.cloudformation.model.CreateStackRequest(
        stackName,
        templateBody.map(value => value),
        templateURL.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableRollback.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        timeoutInMinutes.map(value => value),
        notificationARNs.map(value => value),
        capabilities.map(value => value),
        resourceTypes.map(value => value),
        roleARN.map(value => value),
        onFailure.map(value => value),
        stackPolicyBody.map(value => value),
        stackPolicyURL.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        enableTerminationProtection.map(value => value)
      )
    def stackName: StackName
    def templateBody: Option[TemplateBody]
    def templateURL: Option[TemplateURL]
    def parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def disableRollback: Option[DisableRollback]
    def rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def timeoutInMinutes: Option[TimeoutMinutes]
    def notificationARNs: Option[List[NotificationARN]]
    def capabilities: Option[List[zio.aws.cloudformation.model.Capability]]
    def resourceTypes: Option[List[ResourceType]]
    def roleARN: Option[RoleARN]
    def onFailure: Option[zio.aws.cloudformation.model.OnFailure]
    def stackPolicyBody: Option[StackPolicyBody]
    def stackPolicyURL: Option[StackPolicyURL]
    def tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def clientRequestToken: Option[ClientRequestToken]
    def enableTerminationProtection: Option[EnableTerminationProtection]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getDisableRollback: ZIO[Any, AwsError, DisableRollback] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getTimeoutInMinutes: ZIO[Any, AwsError, TimeoutMinutes] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getOnFailure
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.OnFailure] =
      AwsError.unwrapOptionField("onFailure", onFailure)
    def getStackPolicyBody: ZIO[Any, AwsError, StackPolicyBody] =
      AwsError.unwrapOptionField("stackPolicyBody", stackPolicyBody)
    def getStackPolicyURL: ZIO[Any, AwsError, StackPolicyURL] =
      AwsError.unwrapOptionField("stackPolicyURL", stackPolicyURL)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getEnableTerminationProtection
        : ZIO[Any, AwsError, EnableTerminationProtection] =
      AwsError.unwrapOptionField(
        "enableTerminationProtection",
        enableTerminationProtection
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
  ) extends zio.aws.cloudformation.model.CreateStackRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Option[TemplateURL] = scala
      .Option(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val parameters
        : Option[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Parameter.wrap(item)
        }.toList
      )
    override val disableRollback: Option[DisableRollback] = scala
      .Option(impl.disableRollback())
      .map(value =>
        zio.aws.cloudformation.model.primitives.DisableRollback(value)
      )
    override val rollbackConfiguration
        : Option[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly] =
      scala
        .Option(impl.rollbackConfiguration())
        .map(value =>
          zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
        )
    override val timeoutInMinutes: Option[TimeoutMinutes] = scala
      .Option(impl.timeoutInMinutes())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TimeoutMinutes(value)
      )
    override val notificationARNs: Option[List[NotificationARN]] = scala
      .Option(impl.notificationARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.NotificationARN(item)
        }.toList
      )
    override val capabilities
        : Option[List[zio.aws.cloudformation.model.Capability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Capability.wrap(item)
        }.toList
      )
    override val resourceTypes: Option[List[ResourceType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.ResourceType(item)
        }.toList
      )
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val onFailure: Option[zio.aws.cloudformation.model.OnFailure] =
      scala
        .Option(impl.onFailure())
        .map(value => zio.aws.cloudformation.model.OnFailure.wrap(value))
    override val stackPolicyBody: Option[StackPolicyBody] = scala
      .Option(impl.stackPolicyBody())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackPolicyBody(value)
      )
    override val stackPolicyURL: Option[StackPolicyURL] = scala
      .Option(impl.stackPolicyURL())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackPolicyURL(value)
      )
    override val tags: Option[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
      )
    override val enableTerminationProtection
        : Option[EnableTerminationProtection] = scala
      .Option(impl.enableTerminationProtection())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .EnableTerminationProtection(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
  ): zio.aws.cloudformation.model.CreateStackRequest.ReadOnly = new Wrapper(
    impl
  )
}
