package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChangeSetHookTargetDetails(
    targetType: Option[zio.aws.cloudformation.model.HookTargetType] = None,
    resourceTargetDetails: Option[
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails = {
    import ChangeSetHookTargetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
      .builder()
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        resourceTargetDetails.map(value => value.buildAwsValue())
      )(_.resourceTargetDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly =
    zio.aws.cloudformation.model.ChangeSetHookTargetDetails
      .wrap(buildAwsValue())
}
object ChangeSetHookTargetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ChangeSetHookTargetDetails =
      zio.aws.cloudformation.model.ChangeSetHookTargetDetails(
        targetType.map(value => value),
        resourceTargetDetails.map(value => value.asEditable)
      )
    def targetType: Option[zio.aws.cloudformation.model.HookTargetType]
    def resourceTargetDetails: Option[
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly
    ]
    def getTargetType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HookTargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getResourceTargetDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceTargetDetails", resourceTargetDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
  ) extends zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly {
    override val targetType
        : Option[zio.aws.cloudformation.model.HookTargetType] = scala
      .Option(impl.targetType())
      .map(value => zio.aws.cloudformation.model.HookTargetType.wrap(value))
    override val resourceTargetDetails: Option[
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly
    ] = scala
      .Option(impl.resourceTargetDetails())
      .map(value =>
        zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
  ): zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly =
    new Wrapper(impl)
}
