package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStacksResponse(
    stacks: Option[Iterable[zio.aws.cloudformation.model.Stack]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse = {
    import DescribeStacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
      .builder()
      .optionallyWith(
        stacks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stacks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStacksResponse.wrap(buildAwsValue())
}
object DescribeStacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStacksResponse =
      zio.aws.cloudformation.model.DescribeStacksResponse(
        stacks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stacks: Option[List[zio.aws.cloudformation.model.Stack.ReadOnly]]
    def nextToken: Option[NextToken]
    def getStacks: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Stack.ReadOnly
    ]] = AwsError.unwrapOptionField("stacks", stacks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
  ) extends zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly {
    override val stacks
        : Option[List[zio.aws.cloudformation.model.Stack.ReadOnly]] = scala
      .Option(impl.stacks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.Stack.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
  ): zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly = new Wrapper(
    impl
  )
}
