package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStackSetOperationResponse(
    stackSetOperation: Option[zio.aws.cloudformation.model.StackSetOperation] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse = {
    import DescribeStackSetOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse
      .builder()
      .optionallyWith(stackSetOperation.map(value => value.buildAwsValue()))(
        _.stackSetOperation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackSetOperationResponse
      .wrap(buildAwsValue())
}
object DescribeStackSetOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeStackSetOperationResponse =
      zio.aws.cloudformation.model.DescribeStackSetOperationResponse(
        stackSetOperation.map(value => value.asEditable)
      )
    def stackSetOperation
        : Option[zio.aws.cloudformation.model.StackSetOperation.ReadOnly]
    def getStackSetOperation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperation.ReadOnly
    ] = AwsError.unwrapOptionField("stackSetOperation", stackSetOperation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse
  ) extends zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly {
    override val stackSetOperation
        : Option[zio.aws.cloudformation.model.StackSetOperation.ReadOnly] =
      scala
        .Option(impl.stackSetOperation())
        .map(value =>
          zio.aws.cloudformation.model.StackSetOperation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse
  ): zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly =
    new Wrapper(impl)
}
