package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStackResourcesResponse(
    stackResources: Option[
      Iterable[zio.aws.cloudformation.model.StackResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse = {
    import DescribeStackResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse
      .builder()
      .optionallyWith(
        stackResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackResources)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackResourcesResponse
      .wrap(buildAwsValue())
}
object DescribeStackResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeStackResourcesResponse =
      zio.aws.cloudformation.model.DescribeStackResourcesResponse(
        stackResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stackResources
        : Option[List[zio.aws.cloudformation.model.StackResource.ReadOnly]]
    def getStackResources: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackResource.ReadOnly
    ]] = AwsError.unwrapOptionField("stackResources", stackResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse
  ) extends zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly {
    override val stackResources
        : Option[List[zio.aws.cloudformation.model.StackResource.ReadOnly]] =
      scala
        .Option(impl.stackResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.StackResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse
  ): zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
