package zio.aws.cloudformation.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  Timestamp,
  StackDriftDetectionId,
  StackId,
  BoxedInteger,
  StackDriftDetectionStatusReason
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStackDriftDetectionStatusResponse(
    stackId: StackId,
    stackDriftDetectionId: StackDriftDetectionId,
    stackDriftStatus: Option[zio.aws.cloudformation.model.StackDriftStatus] =
      None,
    detectionStatus: zio.aws.cloudformation.model.StackDriftDetectionStatus,
    detectionStatusReason: Option[StackDriftDetectionStatusReason] = None,
    driftedStackResourceCount: Option[BoxedInteger] = None,
    timestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse = {
    import DescribeStackDriftDetectionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
      .builder()
      .stackId(StackId.unwrap(stackId): java.lang.String)
      .stackDriftDetectionId(
        StackDriftDetectionId.unwrap(stackDriftDetectionId): java.lang.String
      )
      .optionallyWith(stackDriftStatus.map(value => value.unwrap))(
        _.stackDriftStatus
      )
      .detectionStatus(detectionStatus.unwrap)
      .optionallyWith(
        detectionStatusReason.map(value =>
          StackDriftDetectionStatusReason.unwrap(value): java.lang.String
        )
      )(_.detectionStatusReason)
      .optionallyWith(
        driftedStackResourceCount.map(value =>
          BoxedInteger.unwrap(value): Integer
        )
      )(_.driftedStackResourceCount)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse
      .wrap(buildAwsValue())
}
object DescribeStackDriftDetectionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse =
      zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse(
        stackId,
        stackDriftDetectionId,
        stackDriftStatus.map(value => value),
        detectionStatus,
        detectionStatusReason.map(value => value),
        driftedStackResourceCount.map(value => value),
        timestamp
      )
    def stackId: StackId
    def stackDriftDetectionId: StackDriftDetectionId
    def stackDriftStatus: Option[zio.aws.cloudformation.model.StackDriftStatus]
    def detectionStatus: zio.aws.cloudformation.model.StackDriftDetectionStatus
    def detectionStatusReason: Option[StackDriftDetectionStatusReason]
    def driftedStackResourceCount: Option[BoxedInteger]
    def timestamp: Timestamp
    def getStackId: ZIO[Any, Nothing, StackId] = ZIO.succeed(stackId)
    def getStackDriftDetectionId: ZIO[Any, Nothing, StackDriftDetectionId] =
      ZIO.succeed(stackDriftDetectionId)
    def getStackDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackDriftStatus] =
      AwsError.unwrapOptionField("stackDriftStatus", stackDriftStatus)
    def getDetectionStatus: ZIO[
      Any,
      Nothing,
      zio.aws.cloudformation.model.StackDriftDetectionStatus
    ] = ZIO.succeed(detectionStatus)
    def getDetectionStatusReason
        : ZIO[Any, AwsError, StackDriftDetectionStatusReason] =
      AwsError.unwrapOptionField("detectionStatusReason", detectionStatusReason)
    def getDriftedStackResourceCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "driftedStackResourceCount",
        driftedStackResourceCount
      )
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
  ) extends zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly {
    override val stackId: StackId =
      zio.aws.cloudformation.model.primitives.StackId(impl.stackId())
    override val stackDriftDetectionId: StackDriftDetectionId =
      zio.aws.cloudformation.model.primitives
        .StackDriftDetectionId(impl.stackDriftDetectionId())
    override val stackDriftStatus
        : Option[zio.aws.cloudformation.model.StackDriftStatus] = scala
      .Option(impl.stackDriftStatus())
      .map(value => zio.aws.cloudformation.model.StackDriftStatus.wrap(value))
    override val detectionStatus
        : zio.aws.cloudformation.model.StackDriftDetectionStatus =
      zio.aws.cloudformation.model.StackDriftDetectionStatus
        .wrap(impl.detectionStatus())
    override val detectionStatusReason
        : Option[StackDriftDetectionStatusReason] = scala
      .Option(impl.detectionStatusReason())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .StackDriftDetectionStatusReason(value)
      )
    override val driftedStackResourceCount: Option[BoxedInteger] = scala
      .Option(impl.driftedStackResourceCount())
      .map(value => zio.aws.cloudformation.model.primitives.BoxedInteger(value))
    override val timestamp: Timestamp =
      zio.aws.cloudformation.model.primitives.Timestamp(impl.timestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
  ): zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
