package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  NextToken,
  ChangeSetName,
  StackName,
  StackId,
  ChangeSetId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeChangeSetHooksResponse(
    changeSetId: Option[ChangeSetId] = None,
    changeSetName: Option[ChangeSetName] = None,
    hooks: Option[Iterable[zio.aws.cloudformation.model.ChangeSetHook]] = None,
    status: Option[zio.aws.cloudformation.model.ChangeSetHooksStatus] = None,
    nextToken: Option[NextToken] = None,
    stackId: Option[StackId] = None,
    stackName: Option[StackName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksResponse = {
    import DescribeChangeSetHooksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksResponse
      .builder()
      .optionallyWith(
        changeSetId.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(
        changeSetName.map(value =>
          ChangeSetName.unwrap(value): java.lang.String
        )
      )(_.changeSetName)
      .optionallyWith(
        hooks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hooks)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeChangeSetHooksResponse
      .wrap(buildAwsValue())
}
object DescribeChangeSetHooksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeChangeSetHooksResponse =
      zio.aws.cloudformation.model.DescribeChangeSetHooksResponse(
        changeSetId.map(value => value),
        changeSetName.map(value => value),
        hooks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        nextToken.map(value => value),
        stackId.map(value => value),
        stackName.map(value => value)
      )
    def changeSetId: Option[ChangeSetId]
    def changeSetName: Option[ChangeSetName]
    def hooks: Option[List[zio.aws.cloudformation.model.ChangeSetHook.ReadOnly]]
    def status: Option[zio.aws.cloudformation.model.ChangeSetHooksStatus]
    def nextToken: Option[NextToken]
    def stackId: Option[StackId]
    def stackName: Option[StackName]
    def getChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getChangeSetName: ZIO[Any, AwsError, ChangeSetName] =
      AwsError.unwrapOptionField("changeSetName", changeSetName)
    def getHooks: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ChangeSetHook.ReadOnly
    ]] = AwsError.unwrapOptionField("hooks", hooks)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ChangeSetHooksStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksResponse
  ) extends zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly {
    override val changeSetId: Option[ChangeSetId] = scala
      .Option(impl.changeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val changeSetName: Option[ChangeSetName] = scala
      .Option(impl.changeSetName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ChangeSetName(value)
      )
    override val hooks
        : Option[List[zio.aws.cloudformation.model.ChangeSetHook.ReadOnly]] =
      scala
        .Option(impl.hooks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.ChangeSetHook.wrap(item)
          }.toList
        )
    override val status
        : Option[zio.aws.cloudformation.model.ChangeSetHooksStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.cloudformation.model.ChangeSetHooksStatus.wrap(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksResponse
  ): zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly =
    new Wrapper(impl)
}
